/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildStep;
import io.helidon.build.dev.Project;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class BuildComponent {
    private final AtomicReference<Project> project = new AtomicReference();
    private final BuildRoot sourceRoot;
    private final BuildRoot outputRoot;
    private final List<BuildStep> buildSteps;

    public static BuildComponent createBuildComponent(BuildRoot sourceRoot, BuildRoot outputRoot, BuildStep ... buildSteps) {
        return new BuildComponent(sourceRoot, outputRoot, Arrays.asList(buildSteps));
    }

    private BuildComponent(BuildRoot sourceRoot, BuildRoot outputRoot, List<BuildStep> buildSteps) {
        this.sourceRoot = Objects.requireNonNull(sourceRoot).component(this);
        this.outputRoot = Objects.requireNonNull(outputRoot).component(this);
        this.buildSteps = Objects.requireNonNull(buildSteps);
    }

    public Project project() {
        return Objects.requireNonNull(this.project.get());
    }

    public BuildRoot sourceRoot() {
        return this.sourceRoot;
    }

    public BuildRoot outputRoot() {
        return this.outputRoot;
    }

    public List<BuildStep> buildSteps() {
        return this.buildSteps;
    }

    public void incrementalBuild(BuildRoot.Changes changes, Consumer<String> stdOut, Consumer<String> stdErr) throws Exception {
        if (changes.root().component() == this) {
            for (BuildStep step : this.buildSteps) {
                step.incrementalBuild(changes, stdOut, stdErr);
            }
        } else {
            throw new IllegalArgumentException("Changed component != this");
        }
    }

    public void update() {
        this.sourceRoot().update();
        this.outputRoot().update();
    }

    void project(Project project) {
        this.project.set(project);
    }
}

