/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cli.maven.dev;

import io.helidon.build.dev.ProjectSupplier;
import io.helidon.build.dev.maven.DevLoopBuildConfig;
import io.helidon.build.dev.maven.MavenEnvironment;
import io.helidon.build.dev.maven.MavenGoalReferenceResolver;
import io.helidon.build.dev.maven.MavenProjectConfigCollector;
import io.helidon.build.dev.maven.MavenProjectSupplier;
import io.helidon.build.dev.mode.DevLoop;
import io.helidon.build.util.Log;
import io.helidon.build.util.MavenLogWriter;
import io.helidon.build.util.StyleFunction;
import io.helidon.build.util.SystemLogWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dev", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File devProjectDir;
    @Parameter(defaultValue="false", property="dev.clean")
    private boolean clean;
    @Parameter(defaultValue="false", property="dev.fork")
    private boolean fork;
    @Parameter(defaultValue="false", property="dev.terminalMode")
    private boolean terminalMode;
    @Parameter(property="dev.appJvmArgs")
    private String appJvmArgs;
    @Parameter(property="dev.appArgs")
    private String appArgs;
    @Parameter(defaultValue="false", property="dev.skip")
    private boolean skip;
    @Parameter
    private DevLoopBuildConfig devLoop;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager plugins;
    @Component
    private MojoExecutor mojoExecutor;
    @Component
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Component
    private DefaultLifecycles defaultLifeCycles;
    @Component(hint="default")
    private LifecycleMappingDelegate standardDelegate;
    @Component
    private Map<String, LifecycleMappingDelegate> delegates;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        try {
            MavenProjectConfigCollector.assertSupportedProject((MavenSession)this.session);
            if (this.terminalMode) {
                SystemLogWriter.install((Log.Level)(this.getLog().isDebugEnabled() ? Log.Level.DEBUG : Log.Level.INFO));
            } else {
                MavenLogWriter.install((Log)this.getLog());
            }
            if (this.fork) {
                this.warnForkDeprecated();
            }
            DevLoopBuildConfig configuration = this.buildConfig(true);
            MavenProjectSupplier projectSupplier = new MavenProjectSupplier(configuration);
            List<String> jvmArgs = DevMojo.toList(this.appJvmArgs);
            List<String> args = DevMojo.toList(this.appArgs);
            Path dir = this.devProjectDir.toPath();
            DevLoop loop = new DevLoop(dir, (ProjectSupplier)projectSupplier, this.clean, this.fork, this.terminalMode, jvmArgs, args, configuration);
            loop.start(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    DevLoopBuildConfig buildConfig(boolean resolve) throws Exception {
        DevLoopBuildConfig config = this.devLoop == null ? new DevLoopBuildConfig() : this.devLoop;
        config.validate();
        if (resolve) {
            MavenEnvironment env = new MavenEnvironment(this.project, this.session, this.mojoDescriptorCreator, this.defaultLifeCycles, this.standardDelegate, this.delegates, this.plugins, this.mojoExecutor);
            MavenGoalReferenceResolver resolver = new MavenGoalReferenceResolver(env);
            config.resolve(resolver);
        }
        return config;
    }

    private void warnForkDeprecated() {
        this.getLog().warn((CharSequence)StyleFunction.Yellow.apply((Object)"fork mode is deprecated and will be removed in the next major release"));
        try {
            this.getLog().warn((CharSequence)"press enter to continue");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static List<String> toList(String args) {
        return args == null ? Collections.emptyList() : Arrays.asList(args.split(" "));
    }
}

