/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cli.maven.dev;

import io.helidon.build.dev.ProjectSupplier;
import io.helidon.build.dev.maven.MavenProjectSupplier;
import io.helidon.build.dev.mode.DevLoop;
import io.helidon.build.util.Log;
import io.helidon.build.util.MavenLogWriter;
import io.helidon.build.util.SystemLogWriter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dev", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File devProjectDir;
    @Parameter(defaultValue="false", property="dev.clean")
    private boolean clean;
    @Parameter(defaultValue="false", property="dev.fork")
    private boolean fork;
    @Parameter(defaultValue="false", property="dev.terminalMode")
    private boolean terminalMode;
    @Parameter(property="dev.appJvmArgs")
    private String appJvmArgs;
    @Parameter(property="dev.appArgs")
    private String appArgs;
    @Parameter(defaultValue="false", property="dev.skip")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager plugins;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        try {
            if (this.terminalMode) {
                SystemLogWriter.install((Log.Level)(this.getLog().isDebugEnabled() ? Log.Level.DEBUG : Log.Level.INFO));
            } else {
                MavenLogWriter.install((Log)this.getLog());
            }
            MavenProjectSupplier projectSupplier = new MavenProjectSupplier(this.project, this.session, this.plugins);
            List<String> jvmArgs = DevMojo.toList(this.appJvmArgs);
            List<String> args = DevMojo.toList(this.appArgs);
            DevLoop loop = new DevLoop(this.devProjectDir.toPath(), (ProjectSupplier)projectSupplier, this.clean, this.fork, this.terminalMode, jvmArgs, args);
            loop.start(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private static List<String> toList(String args) {
        return args == null ? Collections.emptyList() : Arrays.asList(args.split(" "));
    }
}

