/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.rules;

import io.helidon.build.maven.enforcer.rules.DependencyIsValidCheck;
import io.helidon.build.maven.enforcer.rules.ViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

@Named(value="helidonDependenciesRule")
public class HelidonDependenciesRule
extends AbstractEnforcerRule {
    static final String JAVAX = "javax";
    static final String JAKARTA = "jakarta";
    @Inject
    private MavenProject project;
    @Inject
    private MavenSession session;
    private List<String> excludedGavRegExs;
    private String namespace;

    public void execute() throws ViolationException {
        if (this.excludedGavRegExs == null) {
            this.excludedGavRegExs = List.of();
        }
        String namespace = HelidonDependenciesRule.checkNamespace(this.namespace);
        List<Pattern> excludedGavRegExs = this.excludedGavRegExs.stream().filter(s -> !s.isEmpty()).map(Pattern::compile).collect(Collectors.toList());
        List<Artifact> artifacts = this.project.getArtifacts().stream().filter(a -> a.getGroupId().startsWith("javax.") || a.getGroupId().startsWith("jakarta.")).filter(a -> a.getScope().equalsIgnoreCase("compile") || a.getScope().equalsIgnoreCase("runtime")).filter(a -> !a.isOptional()).collect(Collectors.toList());
        DependencyIsValidCheck check = new DependencyIsValidCheck(namespace, excludedGavRegExs);
        check.validate(artifacts);
    }

    public String toString() {
        return String.format(((Object)((Object)this)).getClass().getSimpleName() + "[namespace=%s, excludedGavRegExs=%s]", this.namespace, this.excludedGavRegExs);
    }

    void setProject(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    void setExcludedGavRegExs(List<String> excludedGavRegExs) {
        this.excludedGavRegExs = new ArrayList<String>((Collection)Objects.requireNonNull(excludedGavRegExs));
    }

    static String checkNamespace(String namespace) {
        if (namespace == null || namespace.isBlank()) {
            return JAKARTA;
        }
        if ((namespace = namespace.toLowerCase().trim()).equals(JAVAX) || namespace.equals(JAKARTA)) {
            return namespace;
        }
        throw new IllegalArgumentException("The namespace '" + namespace + "' is invalid. Only valid namespace names are: 'jakarta' and 'javax'.");
    }
}

