/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.rules;

import io.helidon.build.maven.enforcer.rules.ViolationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

class DependencyIsValidCheck
implements Function<Artifact, Boolean> {
    static final String JAKARTA_RENAMED = "jakarta-renamed.properties";
    static final String JAKARTA_VERSIONS = "jakarta-versions.properties";
    static final String JAKARTA_GROUPS = "jakarta-groups.properties";
    private static final Map<String, VersionRange> PACKAGE_TO_VERSIONS = DependencyIsValidCheck.loadVersions();
    private static final Map<String, String> PACKAGE_TO_RENAMED = DependencyIsValidCheck.loadRenamed();
    private static final Map<String, String> GROUP_TO_PACKAGE = DependencyIsValidCheck.loadGroups();
    private final String namespace;
    private final List<Pattern> excludedGavRegExs;

    DependencyIsValidCheck(String namespace, List<Pattern> excludedGavRegExs) {
        this.namespace = namespace;
        this.excludedGavRegExs = excludedGavRegExs;
    }

    @Override
    public Boolean apply(Artifact gav) {
        if (this.isExcluded(DependencyIsValidCheck.toSimpleGav(gav))) {
            return true;
        }
        String groupPackageName = this.toPackage(gav.getGroupId());
        if (groupPackageName.equals("javax.servlet") || groupPackageName.equals("jakarta.servlet")) {
            return false;
        }
        try {
            if ("jakarta".equalsIgnoreCase(this.namespace)) {
                return this.applyJakartaRule(groupPackageName, gav.getSelectedVersion());
            }
            if ("javax".equalsIgnoreCase(this.namespace)) {
                return this.applyJavaxRule(groupPackageName, gav.getSelectedVersion());
            }
            throw new IllegalStateException("Invalid namespace: " + this.namespace);
        }
        catch (OverConstrainedVersionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean apply(String gav) {
        return this.apply((Artifact)DependencyIsValidCheck.toArtifact(gav));
    }

    public void validate(String ... gavs) throws ViolationException {
        this.validate(Arrays.stream(gavs).map(DependencyIsValidCheck::toArtifact).collect(Collectors.toList()));
    }

    public void validate(Collection<Artifact> gavs) throws ViolationException {
        ArrayList<String> violations = new ArrayList<String>();
        for (Artifact gav : gavs) {
            if (this.apply(gav).booleanValue()) continue;
            violations.add(DependencyIsValidCheck.toSimpleGav(gav));
        }
        if (!violations.isEmpty()) {
            throw new ViolationException("Bad dependencies spotted (review with mvn dependency:tree): " + violations, violations);
        }
    }

    boolean applyJakartaRule(String groupPackageName, ArtifactVersion version) {
        VersionRange versionRange;
        if (groupPackageName.startsWith("javax.")) {
            String renamedPackage = PACKAGE_TO_RENAMED.get(groupPackageName);
            return renamedPackage == null;
        }
        if (groupPackageName.startsWith("jakarta.") && (versionRange = PACKAGE_TO_VERSIONS.get(groupPackageName)) != null) {
            return versionRange.containsVersion(version);
        }
        return true;
    }

    boolean applyJavaxRule(String groupPackageName, ArtifactVersion version) {
        VersionRange versionRange;
        if (groupPackageName.startsWith("jakarta.") && (versionRange = PACKAGE_TO_VERSIONS.get(groupPackageName)) != null) {
            return !versionRange.containsVersion(version);
        }
        return true;
    }

    String toPackage(String group) {
        String packageName = GROUP_TO_PACKAGE.get(group);
        return packageName == null ? group : packageName;
    }

    boolean isExcluded(String groupPackageName) {
        for (Pattern pattern : this.excludedGavRegExs) {
            if (!pattern.matcher(groupPackageName).matches()) continue;
            return true;
        }
        return false;
    }

    static DefaultArtifact toArtifact(String gav) {
        String[] split = gav.split(":");
        DefaultArtifact artifact = new DefaultArtifact(split[0], split.length > 1 ? split[1] : "", split.length > 2 ? split[2] : null, split.length > 3 ? split[3] : "compile", split.length > 4 ? split[4] : "jar", split.length > 5 ? split[5] : "", null);
        return artifact;
    }

    static Map<String, VersionRange> loadVersions() {
        LinkedHashMap<String, VersionRange> result = new LinkedHashMap<String, VersionRange>();
        DependencyIsValidCheck.load(JAKARTA_VERSIONS).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            try {
                result.put(k.toString(), VersionRange.createFromVersionSpec((String)v.toString()));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalStateException(e);
            }
        }));
        return result;
    }

    static Map<String, String> loadRenamed() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        DependencyIsValidCheck.load(JAKARTA_RENAMED).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v.toString())));
        return result;
    }

    static Map<String, String> loadGroups() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        DependencyIsValidCheck.load(JAKARTA_GROUPS).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v.toString())));
        return result;
    }

    static Properties load(String name) {
        Properties props = new Properties();
        try (InputStream is = DependencyIsValidCheck.class.getClassLoader().getResourceAsStream(name);){
            props.load(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return props;
    }

    static String toSimpleGav(Artifact gav) {
        return gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion();
    }
}

