/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.ConfigAdapter;
import io.helidon.build.maven.cache.ConfigConverters;
import io.helidon.build.maven.cache.ConfigDiffs;
import io.helidon.build.maven.cache.ConfigVisitor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ConfigNode {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final ConfigAdapter orig;
    private final ConfigNode parent;
    private final Map<String, String> attributes;
    private List<ConfigNode> children;
    private String value;
    private final String name;
    private final int id;

    ConfigNode(ConfigAdapter orig, ConfigNode parent) {
        this.orig = Objects.requireNonNull(orig, "orig is null");
        this.parent = parent;
        this.attributes = orig.attributes();
        this.name = orig.name();
        this.value = orig.value();
        this.id = NEXT_ID.incrementAndGet();
    }

    void visit(final Consumer<ConfigNode> function) {
        new ConfigVisitor(){

            @Override
            boolean enteringTreeNode(ConfigNode node) {
                function.accept(node);
                return true;
            }

            @Override
            void leafNode(ConfigNode node) {
                function.accept(node);
            }
        }.visit(this);
    }

    int id() {
        return this.id;
    }

    String name() {
        return this.name;
    }

    String value() {
        return this.value;
    }

    void value(String newValue) {
        this.value = newValue;
    }

    Map<String, String> attributes() {
        return this.attributes;
    }

    ConfigNode parent() {
        return this.parent;
    }

    boolean hasChildren() {
        return !this.children().isEmpty();
    }

    List<ConfigNode> children() {
        if (this.children == null) {
            this.children = new LinkedList<ConfigNode>();
            for (ConfigAdapter child : this.orig.children()) {
                this.children.add(new ConfigNode(child, this));
            }
        }
        return this.children;
    }

    ConfigDiffs diff(ConfigNode node) {
        return new ConfigDiffs(this, node);
    }

    int index() {
        int index = 0;
        int count = 0;
        if (this.parent != null) {
            for (ConfigNode child : this.parent.children()) {
                if (child.equals(this)) {
                    index = count;
                }
                ++count;
            }
        }
        return index;
    }

    String path() {
        if (this.parent == null) {
            return "/";
        }
        Object path = "";
        ConfigNode n = this;
        while (n.parent != null) {
            path = "/" + n.parent.name + "{" + n.index() + "}" + (String)path;
            n = n.parent;
        }
        return path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigNode that = (ConfigNode)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    Xpp3Dom toXpp3Dom() {
        return ConfigConverters.toXpp3Dom(this);
    }

    public String toString() {
        return ConfigConverters.toString(this);
    }
}

