/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ProjectExecutionManager;
import io.helidon.build.maven.cache.ProjectFiles;
import io.helidon.build.maven.cache.ProjectState;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ProjectStateManager.class, hint="default")
public class ProjectStateManager {
    @Requirement
    private Logger logger;
    @Requirement
    private MavenSession session;
    @Requirement
    private ProjectExecutionManager executionManager;
    private final Map<MavenProject, ProjectStateStatus> statesStatuses = new HashMap<MavenProject, ProjectStateStatus>();

    public Map<MavenProject, ProjectStateStatus> statesStatuses() {
        return this.statesStatuses;
    }

    public Map<MavenProject, ProjectStateStatus> processStates(MavenSession session) {
        ProjectDependencyGraph pdg = session.getProjectDependencyGraph();
        HashMap<MavenProject, ProjectStateStatus> statusMap = new HashMap<MavenProject, ProjectStateStatus>();
        LinkedList<MavenProject> stack = new LinkedList<MavenProject>(session.getProjects());
        block0: while (!stack.isEmpty()) {
            MavenProject project = (MavenProject)stack.pop();
            ProjectStateStatus stateStatus = statusMap.computeIfAbsent(project, this::processState);
            if (stateStatus.code() != 0) continue;
            for (MavenProject upstream : pdg.getUpstreamProjects(project, true)) {
                ProjectStateStatus uss = statusMap.computeIfAbsent(upstream, this::processState);
                if (uss.code() == 0) continue;
                statusMap.put(project, stateStatus.invalidate());
                for (MavenProject downstream : pdg.getDownstreamProjects(project, true)) {
                    if (stack.contains(downstream)) continue;
                    stack.addLast(downstream);
                }
                continue block0;
            }
        }
        return statusMap;
    }

    private ProjectStateStatus processState(MavenProject project) {
        ProjectFiles projectFiles;
        ProjectState state;
        if (CacheConfig.of(project, this.session).skip()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("[%s:%s] - cache.skip is true, not loading state", project.getGroupId(), project.getArtifactId()));
            }
            return ProjectStateStatus.UNAVAILABLE;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("[%s:%s] - loading state", project.getGroupId(), project.getArtifactId()));
            }
            if ((state = ProjectState.load(project)) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("[%s:%s] - state file not found", project.getGroupId(), project.getArtifactId()));
                }
                return ProjectStateStatus.UNAVAILABLE;
            }
        }
        catch (IOException | XmlPullParserException ex) {
            this.logger.error("Error while loading project state for " + project, ex);
            return ProjectStateStatus.UNAVAILABLE;
        }
        try {
            projectFiles = ProjectFiles.of(project, this.session);
        }
        catch (IOException ex) {
            this.logger.error("Error while checking project files for " + project, (Throwable)ex);
            return ProjectStateStatus.UNAVAILABLE;
        }
        if (!state.projectFiles().equals(projectFiles)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("[%s:%s] - files changed - state is invalid", project.getGroupId(), project.getArtifactId()));
            }
            return new ProjectStateStatus(2, state, projectFiles);
        }
        ProjectStateStatus stateStatus = new ProjectStateStatus(0, state, projectFiles);
        this.statesStatuses.put(project, stateStatus);
        return stateStatus;
    }

    public void save(MavenProject project, MavenSession session) {
        try {
            ProjectState projectState = null;
            ProjectFiles projectFiles = null;
            ProjectStateStatus stateStatus = this.statesStatuses.get(project);
            if (stateStatus != null && stateStatus.code() != 1) {
                projectFiles = stateStatus.projectFiles();
                projectState = stateStatus.state();
            }
            List<ExecutionEntry> newExecutions = this.executionManager.recordedExecutions(project);
            ProjectState.merge(projectState, project, session, newExecutions, projectFiles).save(project);
        }
        catch (IOException | UncheckedIOException ex) {
            this.logger.error("Error while saving project state", (Throwable)ex);
        }
    }
}

