/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.SourcePath;
import io.helidon.build.maven.cache.ConfigAdapters;
import io.helidon.build.maven.cache.ConfigNode;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class ExecutionEntry {
    private static final List<String> DEFAULT_INCLUDES = List.of("*");
    static final String XML_ELEMENT_NAME = "execution";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String goal;
    private final String executionId;
    private final ConfigNode configuration;

    ExecutionEntry(String groupId, String artifactId, String version, String goal, String executionId, ConfigNode configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goal = goal;
        this.executionId = executionId;
        this.configuration = configuration;
    }

    String groupId() {
        return this.groupId;
    }

    String artifactId() {
        return this.artifactId;
    }

    String version() {
        return this.version;
    }

    String executionId() {
        return this.executionId;
    }

    String goal() {
        return this.goal;
    }

    ConfigNode config() {
        return this.configuration;
    }

    boolean matches(ExecutionEntry execution) {
        return this.groupId.equals(execution.groupId) && this.artifactId.equals(execution.artifactId) && this.version.equals(execution.version) && this.goal.equals(execution.goal) && this.executionId.equals(execution.executionId);
    }

    boolean matches(Plugin plugin, String goal, String id) {
        return this.groupId.equals(plugin.getGroupId()) && this.artifactId.equals(plugin.getArtifactId()) && this.version.equals(plugin.getVersion()) && this.goal.equals(goal) && this.executionId.equals(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionEntry execution = (ExecutionEntry)o;
        return this.groupId.equals(execution.groupId) && this.artifactId.equals(execution.artifactId) && this.version.equals(execution.version) && this.goal.equals(execution.goal) && this.executionId.equals(execution.executionId) && Objects.equals(this.configuration, execution.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.goal, this.executionId, this.configuration);
    }

    String name() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.goal + "@" + this.executionId;
    }

    boolean match(List<String> includes, List<String> excludes) {
        if (includes == null || includes.isEmpty()) {
            includes = DEFAULT_INCLUDES;
        }
        String execName = this.name();
        for (String include : includes) {
            if (SourcePath.wildcardMatch((String)execName, (String)include)) continue;
            return false;
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!SourcePath.wildcardMatch((String)execName, (String)exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ExecutionEntry{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', goal='" + this.goal + "', executionId='" + this.executionId + "', configuration='" + this.configuration + "'}";
    }

    Xpp3Dom toXml() {
        Xpp3Dom elt = new Xpp3Dom(XML_ELEMENT_NAME);
        elt.setAttribute("groupId", this.groupId);
        elt.setAttribute("artifactId", this.artifactId);
        elt.setAttribute("version", this.version);
        elt.setAttribute("goal", this.goal);
        elt.setAttribute("id", this.executionId);
        if (this.configuration != null) {
            elt.addChild(this.configuration.toXpp3Dom());
        }
        return elt;
    }

    static ExecutionEntry fromXml(Xpp3Dom elt) {
        ConfigNode config = new ConfigNode(ConfigAdapters.create(elt.getChild("configuration")), null);
        return new ExecutionEntry(elt.getAttribute("groupId"), elt.getAttribute("artifactId"), elt.getAttribute("version"), elt.getAttribute("goal"), elt.getAttribute("id"), config);
    }

    static ExecutionEntry create(MojoExecution execution, ConfigNode configuration) {
        return new ExecutionEntry(execution.getGroupId(), execution.getArtifactId(), execution.getVersion(), execution.getGoal(), execution.getExecutionId(), configuration);
    }
}

