/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.ConfigDiffs;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ExecutionStatus;
import io.helidon.build.maven.cache.ProjectState;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.util.List;
import java.util.stream.Collectors;

final class ProjectExecutionPlan {
    private final List<ExecutionStatus> executionStatuses;
    private final ProjectStateStatus stateStatus;

    ProjectExecutionPlan(ProjectStateStatus stateStatus, List<ExecutionEntry> executions) {
        this.stateStatus = stateStatus;
        ProjectState state = stateStatus.state();
        this.executionStatuses = executions.stream().map(exec -> {
            if (state.hasMatchingExecution((ExecutionEntry)exec)) {
                ConfigDiffs diffs = state.findMatchingExecution((ExecutionEntry)exec).config().diff(exec.config());
                if (diffs.hasNext()) {
                    return new ExecutionStatus(2, (ExecutionEntry)exec, diffs);
                }
                return new ExecutionStatus(0, (ExecutionEntry)exec, null);
            }
            return new ExecutionStatus(1, (ExecutionEntry)exec, null);
        }).collect(Collectors.toList());
    }

    ProjectStateStatus stateStatus() {
        return this.stateStatus;
    }

    List<ExecutionStatus> executionStatuses() {
        return this.executionStatuses;
    }

    List<ExecutionEntry> cachedExecutions() {
        return this.executionStatuses.stream().filter(ExecutionStatus::isCached).map(ExecutionStatus::execution).collect(Collectors.toList());
    }

    boolean allCached() {
        return this.executionStatuses.stream().allMatch(ExecutionStatus::isCached);
    }

    boolean hasFileChanges() {
        return this.stateStatus.code() == 2;
    }

    public boolean hasInvalidDownstream() {
        return this.stateStatus.code() == 3;
    }
}

