/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.Diff;
import io.helidon.build.maven.cache.ProjectFiles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

final class ProjectFilesDiffs
implements Iterator<Diff> {
    private final Iterator<Diff> iterator;

    ProjectFilesDiffs(ProjectFiles orig, ProjectFiles actual) {
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (actual != null) {
            if (orig.filesCount() != actual.filesCount()) {
                diffs.add(new Diff(orig.filesCount(), actual.filesCount(), "count"));
            }
            if (orig.lastModified() != actual.lastModified()) {
                diffs.add(new Diff(orig.lastModified(), actual.lastModified(), "last-modified"));
            }
            if (!Objects.equals(orig.checksum(), actual.checksum())) {
                diffs.add(new Diff(orig.checksum(), actual.checksum(), "checksum"));
            }
            Map<String, String> ocs = orig.allChecksums();
            Map<String, String> acs = actual.allChecksums();
            ocs.entrySet().stream().filter(e -> !((String)e.getValue()).equals(acs.get(e.getKey()))).forEach(e -> diffs.add(new Diff(e.getValue(), acs.get(e.getKey()), (String)e.getKey())));
            acs.entrySet().stream().filter(e -> !ocs.containsKey(e.getKey())).forEach(e -> diffs.add(new Diff(ocs.get(e.getKey()), e.getValue(), (String)e.getKey())));
        }
        this.iterator = diffs.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Diff next() {
        return this.iterator.next();
    }
}

