/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.ConfigResolver;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ProjectExecutionPlan;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ProjectExecutionManager.class, hint="default")
public class ProjectExecutionManager {
    private final Map<MavenProject, List<ExecutionEntry>> recordedExecutions = new HashMap<MavenProject, List<ExecutionEntry>>();
    private final Map<MavenProject, ProjectExecutionPlan> executionPlans = new HashMap<MavenProject, ProjectExecutionPlan>();
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement(hint="default")
    private LifecycleMappingDelegate standardLifecycleDelegate;
    @Requirement
    private Map<String, LifecycleMappingDelegate> lifecycleDelegates;
    @Requirement
    private ConfigResolver configResolver;
    @Requirement
    private Logger logger;

    public void processExecutions(MavenSession session, MavenProject project, ProjectStateStatus stateStatus) {
        if (stateStatus.code() == 2 || stateStatus.code() == 3) {
            this.executionPlans.put(project, new ProjectExecutionPlan(stateStatus, List.of()));
            return;
        }
        List<ExecutionEntry> execs = this.resolveExecutions(session, project);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%s:%s] - executions in the current life-cycle: \n  %s", project.getGroupId(), project.getArtifactId(), execs.stream().map(ExecutionEntry::name).collect(Collectors.joining("\n  "))));
        }
        ProjectExecutionPlan execPlan = new ProjectExecutionPlan(stateStatus, execs);
        this.executionPlans.put(project, execPlan);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%s:%s] - execution statuses:\n  %s", project.getGroupId(), project.getArtifactId(), execPlan.executionStatuses().stream().map(s -> {
                Object str = s.toString();
                if (s.isDiff()) {
                    str = (String)str + "\n" + s.diffs().stream().map(d -> "             +- " + d.asString()).collect(Collectors.joining());
                }
                return str;
            }).collect(Collectors.joining("\n  "))));
        }
        project.getBuild().getPlugins().forEach(plugin -> this.removePluginExecutions((Plugin)plugin, execPlan.cachedExecutions()));
    }

    public ProjectExecutionPlan plan(MavenProject project) {
        return this.executionPlans.get(project);
    }

    public void recordExecution(MojoExecution execution, MavenSession session, MavenProject project) {
        ExecutionEntry executionRecord = ExecutionEntry.create(execution, this.configResolver.resolve(execution, session, project));
        if (!this.isCleanExecution(session, project, executionRecord) && !MojoExecution.Source.CLI.equals((Object)execution.getSource())) {
            this.recordedExecutions.computeIfAbsent(project, p -> new LinkedList()).add(executionRecord);
        }
    }

    public List<ExecutionEntry> recordedExecutions(MavenProject project) {
        return this.recordedExecutions.getOrDefault(project, List.of());
    }

    private List<ExecutionEntry> resolveExecutions(MavenSession session, MavenProject project) {
        CacheConfig cacheConfig = CacheConfig.of(project, session);
        List<String> includes = cacheConfig.executionsIncludes();
        List<String> excludes = cacheConfig.executionsExcludes();
        return session.getGoals().stream().filter(phase -> !phase.equals("clean")).flatMap(phase -> this.resolvePhase(session, project, (String)phase).stream()).map(exec -> ExecutionEntry.create(exec, this.configResolver.resolve((MojoExecution)exec, session, project))).filter(exec -> exec.match(includes, excludes)).collect(Collectors.toList());
    }

    private List<MojoExecution> resolvePhase(MavenSession session, MavenProject project, String phase) {
        Lifecycle lifecycle = this.defaultLifeCycles.get(phase);
        LifecycleMappingDelegate lifecycleDelegate = null;
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) < 0) {
            lifecycleDelegate = this.lifecycleDelegates.get(lifecycle.getId());
        }
        if (lifecycleDelegate == null) {
            lifecycleDelegate = this.standardLifecycleDelegate;
        }
        try {
            return lifecycleDelegate.calculateLifecycleMappings(session, project, lifecycle, phase).entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        }
        catch (InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException e2) {
            this.logger.warn("Unable to resolve mojos for phase: " + phase, e2);
            return List.of();
        }
    }

    private boolean isCleanExecution(MavenSession session, MavenProject project, ExecutionEntry execution) {
        return this.resolvePhase(session, project, "clean").stream().map(e -> ExecutionEntry.create(e, null)).anyMatch(e -> e.matches(execution));
    }

    private void removePluginExecutions(Plugin plugin, List<ExecutionEntry> executions) {
        plugin.getExecutions().forEach(pluginExec -> {
            Iterator it = pluginExec.getGoals().iterator();
            while (it.hasNext()) {
                String goal = (String)it.next();
                if (!executions.stream().anyMatch(e -> e.matches(plugin, goal, pluginExec.getId()))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Skipping: " + plugin.getId() + "@" + pluginExec.getId());
                }
                it.remove();
            }
        });
        plugin.getExecutions().removeIf(pluginExecution -> pluginExecution.getGoals().isEmpty());
    }
}

