/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.CacheArchiveManager;
import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.ConfigDiffs;
import io.helidon.build.maven.cache.DelegatingExecutionListener;
import io.helidon.build.maven.cache.ProjectExecutionManager;
import io.helidon.build.maven.cache.ProjectExecutionPlan;
import io.helidon.build.maven.cache.ProjectStateManager;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="build-cache")
public class LifecycleParticipantImpl
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private ProjectStateManager stateManager;
    @Requirement
    private CacheArchiveManager cacheManager;
    @Requirement
    private ProjectExecutionManager executionManager;
    @Requirement
    private Logger logger;
    private CacheConfig config;

    public void afterProjectsRead(MavenSession session) {
        this.config = CacheConfig.of(session.getTopLevelProject(), session);
        if (this.config.skip()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping build-cache");
            }
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("cache.archive=" + this.config.archiveFile());
        }
        this.logger.info("");
        this.logger.info("----------------------------{ build-cache }-----------------------------");
        if (this.config.loadArchive() && this.config.archiveFile() != null && Files.exists(this.config.archiveFile(), new LinkOption[0])) {
            this.cacheManager.loadCache(session, this.config.archiveFile());
        }
        if (session.getGoals().contains("clean")) {
            this.logger.info("Clean requested, state is ignored.");
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processing state files...");
            }
            for (Map.Entry<MavenProject, ProjectStateStatus> entry : this.stateManager.processStates(session).entrySet()) {
                MavenProject project = entry.getKey();
                ProjectStateStatus stateStatus = entry.getValue();
                if (stateStatus.code() == 1) continue;
                if (stateStatus.code() == 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("[%s:%s] - applying state", project.getGroupId(), project.getArtifactId()));
                    }
                    stateStatus.state().apply(project, session);
                }
                this.executionManager.processExecutions(session, project, stateStatus);
            }
            this.logger.info("Loaded " + this.stateManager.statesStatuses().size() + " state file(s)");
        }
        MavenExecutionRequest request = session.getRequest();
        request.setExecutionListener((ExecutionListener)new ExecutionListenerImpl(request.getExecutionListener()));
        this.logger.info("------------------------------------------------------------------------");
    }

    public void afterSessionEnd(MavenSession session) {
        if (!this.config.skip() && this.config.archiveFile() != null && this.config.createArchive()) {
            this.logger.info("");
            this.logger.info("----------------------------{ build-cache }-----------------------------");
            this.cacheManager.save(session, this.config.archiveFile());
            this.logger.info("------------------------------------------------------------------------");
        }
    }

    private final class ExecutionListenerImpl
    extends DelegatingExecutionListener {
        ExecutionListenerImpl(ExecutionListener delegate) {
            super(delegate);
        }

        @Override
        public void projectStarted(ExecutionEvent event) {
            super.projectStarted(event);
            MavenProject project = event.getProject();
            ProjectExecutionPlan plan = LifecycleParticipantImpl.this.executionManager.plan(project);
            boolean skip = CacheConfig.of(event.getProject(), event.getSession()).skip();
            if (plan != null || skip) {
                LifecycleParticipantImpl.this.logger.info("");
                LifecycleParticipantImpl.this.logger.info("----------------------------{ build-cache }-----------------------------");
                if (skip) {
                    LifecycleParticipantImpl.this.logger.info("Cache is disabled.");
                } else if (plan.hasInvalidDownstream()) {
                    LifecycleParticipantImpl.this.logger.info("Downstream state(s) not available, state is ignored.");
                } else if (!plan.hasFileChanges() && plan.allCached()) {
                    LifecycleParticipantImpl.this.logger.info("All executions are cached! (fast-forward)");
                } else if (plan.hasFileChanges()) {
                    LifecycleParticipantImpl.this.logger.info("File changes detected, state is ignored.");
                    ProjectStateStatus stateStatus = plan.stateStatus();
                    stateStatus.state().projectFiles().diff(stateStatus.projectFiles()).forEachRemaining(diff -> LifecycleParticipantImpl.this.logger.info("  +- " + diff.asString()));
                } else {
                    plan.executionStatuses().stream().filter(s -> !s.isNew()).forEach(s -> {
                        LifecycleParticipantImpl.this.logger.info(s.toString());
                        if (s.isDiff()) {
                            ConfigDiffs diffs = s.diffs().rewind();
                            while (diffs.hasNext()) {
                                LifecycleParticipantImpl.this.logger.info("           +- " + diffs.next().asString());
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void mojoSucceeded(ExecutionEvent event) {
            LifecycleParticipantImpl.this.executionManager.recordExecution(event.getMojoExecution(), event.getSession(), event.getProject());
            super.mojoSucceeded(event);
        }

        @Override
        public void projectSucceeded(ExecutionEvent event) {
            LifecycleParticipantImpl.this.stateManager.save(event.getProject(), event.getSession());
            super.projectSucceeded(event);
        }
    }
}

