/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.ConfigAdapters;
import io.helidon.build.maven.cache.ConfigNode;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.logging.Logger;

@Component(role=ConfigResolver.class, hint="default")
public class ConfigResolver {
    @Requirement
    private LifecycleExecutionPlanCalculator executionPlanCalculator;
    @Requirement
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigNode resolve(MojoExecution execution, MavenSession session, MavenProject project) {
        MavenProject currentProject = session.getCurrentProject();
        try {
            this.executionPlanCalculator.setupMojoExecution(session, project, execution);
            session.setCurrentProject(project);
            ExpressionEvaluator evaluator = new ExpressionEvaluator(session, execution);
            ConfigNode config = new ConfigNode(ConfigAdapters.create(execution.getConfiguration()), null);
            config.visit(node -> {
                node.attributes().entrySet().forEach(e -> e.setValue(this.evaluateExpression(evaluator, (String)e.getValue())));
                String value = node.value();
                if (value != null) {
                    node.value(this.evaluateExpression(evaluator, value));
                }
            });
            ConfigNode configNode = config;
            return configNode;
        }
        catch (LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException ex) {
            this.logger.error("Unable to configure mojo: " + execution, ex);
            ConfigNode configNode = null;
            return configNode;
        }
        finally {
            session.setCurrentProject(currentProject);
        }
    }

    private String evaluateExpression(ExpressionEvaluator evaluator, String value) {
        return Optional.ofNullable(value).map(v -> {
            try {
                Object result = evaluator.evaluate((String)v);
                if (result instanceof String) {
                    return (String)result;
                }
                return v;
            }
            catch (ExpressionEvaluationException e) {
                this.logger.error("Unable to evaluate expression: " + v, (Throwable)e);
                return v;
            }
        }).orElse("");
    }

    private static final class ExpressionEvaluator
    extends PluginParameterExpressionEvaluator {
        private final String execRootDir;

        ExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
            super(session, mojoExecution);
            this.execRootDir = session.getExecutionRootDirectory();
        }

        public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
            Object val = super.evaluate(expr, type);
            if (val instanceof String) {
                return ((String)val).replace(this.execRootDir, "#{exec.root.dir}");
            }
            return val;
        }
    }
}

