/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class CacheConfig {
    private static final String GROUPID = "io.helidon.build-tools";
    private static final String ARTIFACTID = "helidon-build-cache-maven-plugin";
    private static final String POM_PROPERTIES = "META-INF/maven/io.helidon.build-tools/helidon-build-cache-maven-plugin/pom.properties";
    private static String version;
    private static final Properties EMPTY_PROPS;
    private static final CacheConfig EMPTY_CONFIG;
    private static final WeakHashMap<MavenProject, CacheConfig> CONFIG_CACHE;
    private final List<String> executionsExcludes;
    private final List<String> executionsIncludes;
    private final List<String> projectFilesExcludes;
    private final List<String> buildFilesExcludes;
    private final boolean enableChecksums;
    private final boolean includeAllChecksums;
    private final Path archiveFile;
    private final boolean skip;
    private final boolean createArchive;
    private final boolean loadArchive;

    private CacheConfig(Xpp3Dom config, MavenSession session) {
        Properties userProps;
        Properties sysProps;
        if (session == null) {
            sysProps = System.getProperties();
            userProps = EMPTY_PROPS;
        } else {
            sysProps = session.getSystemProperties();
            userProps = session.getUserProperties();
        }
        List<String> executionsExcludes = CacheConfig.stringListProperty(sysProps, userProps, "cache.executionsExcludes");
        List<String> executionsIncludes = CacheConfig.stringListProperty(sysProps, userProps, "cache.executionsIncludes");
        List<String> projectFilesExcludes = CacheConfig.stringListProperty(sysProps, userProps, "cache.projectFilesExcludes");
        List<String> buildFilesExcludes = CacheConfig.stringListProperty(sysProps, userProps, "cache.buildFilesExcludes");
        Path archiveFile = CacheConfig.pathProperty(sysProps, userProps, "cache.archiveFile");
        Boolean enableChecksums = CacheConfig.booleanProperty(sysProps, userProps, "cache.enableChecksums");
        Boolean includeAllChecksums = CacheConfig.booleanProperty(sysProps, userProps, "cache.includeAllChecksums");
        Boolean skip = CacheConfig.booleanProperty(sysProps, userProps, "cache.skip");
        Boolean createArchive = CacheConfig.booleanProperty(sysProps, userProps, "cache.createArchive");
        Boolean loadArchive = CacheConfig.booleanProperty(sysProps, userProps, "cache.loadArchive");
        if (config != null) {
            if (executionsIncludes == null) {
                executionsIncludes = CacheConfig.stringListElement(config, "executionsIncludes");
            }
            if (executionsExcludes == null) {
                executionsExcludes = CacheConfig.stringListElement(config, "executionsExcludes");
            }
            if (projectFilesExcludes == null) {
                projectFilesExcludes = CacheConfig.stringListElement(config, "projectFilesExcludes");
            }
            if (buildFilesExcludes == null) {
                buildFilesExcludes = CacheConfig.stringListElement(config, "buildFilesExcludes");
            }
            if (archiveFile == null) {
                archiveFile = CacheConfig.pathElement(config, "archiveFile");
            }
            if (enableChecksums == null) {
                enableChecksums = CacheConfig.booleanElement(config, "enableChecksums");
            }
            if (includeAllChecksums == null) {
                includeAllChecksums = CacheConfig.booleanElement(config, "includeAllChecksums");
            }
            if (createArchive == null) {
                createArchive = CacheConfig.booleanElement(config, "createArchive");
            }
            if (loadArchive == null) {
                loadArchive = CacheConfig.booleanElement(config, "loadArchive");
            }
            if (skip == null) {
                skip = CacheConfig.booleanElement(config, "skip");
            }
        }
        this.enableChecksums = enableChecksums != null && enableChecksums != false;
        this.includeAllChecksums = includeAllChecksums != null && includeAllChecksums != false;
        this.skip = skip != null && skip != false;
        this.archiveFile = archiveFile;
        this.createArchive = createArchive != null && createArchive != false;
        this.loadArchive = loadArchive != null && loadArchive != false;
        this.executionsExcludes = executionsExcludes != null ? executionsExcludes : List.of();
        this.executionsIncludes = executionsIncludes != null ? executionsIncludes : List.of();
        this.projectFilesExcludes = projectFilesExcludes != null ? projectFilesExcludes : List.of();
        this.buildFilesExcludes = buildFilesExcludes != null ? buildFilesExcludes : List.of();
    }

    List<String> buildFilesExcludes() {
        return this.buildFilesExcludes;
    }

    List<String> projectFilesExcludes() {
        return this.projectFilesExcludes;
    }

    boolean enableChecksums() {
        return this.enableChecksums;
    }

    boolean includeAllChecksums() {
        return this.includeAllChecksums;
    }

    Path archiveFile() {
        return this.archiveFile;
    }

    boolean loadArchive() {
        return this.loadArchive;
    }

    boolean createArchive() {
        return this.createArchive;
    }

    boolean skip() {
        return this.skip;
    }

    List<String> executionsExcludes() {
        return this.executionsExcludes;
    }

    List<String> executionsIncludes() {
        return this.executionsIncludes;
    }

    static CacheConfig of(MavenProject project, MavenSession session) {
        return CONFIG_CACHE.computeIfAbsent(project, p -> CacheConfig.loadConfig(p, session));
    }

    private static CacheConfig loadConfig(MavenProject project, MavenSession session) {
        CacheConfig.loadVersion();
        for (Plugin buildPlugin : project.getBuildPlugins()) {
            if (!GROUPID.equals(buildPlugin.getGroupId()) || !ARTIFACTID.equals(buildPlugin.getArtifactId()) || version == null || !buildPlugin.getVersion().equals(version)) continue;
            Object config = buildPlugin.getConfiguration();
            if (!(config instanceof Xpp3Dom)) break;
            return new CacheConfig((Xpp3Dom)config, session);
        }
        return EMPTY_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadVersion() {
        if (version != null) return;
        Class<CacheConfig> clazz = CacheConfig.class;
        synchronized (CacheConfig.class) {
            if (version != null) return;
            Properties props = new Properties();
            InputStream is = CacheConfig.class.getClassLoader().getResourceAsStream(POM_PROPERTIES);
            if (is == null) return;
            try {
                props.load(is);
                version = props.getProperty("version");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private static List<String> stringListElement(Xpp3Dom config, String eltName) {
        Xpp3Dom elt = config.getChild(eltName);
        if (elt != null) {
            LinkedList<String> list = new LinkedList<String>();
            for (Xpp3Dom exclude : elt.getChildren()) {
                String value = exclude.getValue();
                if (value == null || value.isEmpty()) continue;
                list.add(value);
            }
            return list;
        }
        return null;
    }

    private static Path pathElement(Xpp3Dom config, String eltName) {
        String value;
        Xpp3Dom elt = config.getChild(eltName);
        if (elt != null && (value = elt.getValue()) != null && !value.isEmpty()) {
            return Path.of(value, new String[0]);
        }
        return null;
    }

    private static Boolean booleanElement(Xpp3Dom config, String eltName) {
        Xpp3Dom elt = config.getChild(eltName);
        if (elt != null) {
            String value = elt.getValue();
            return value.isEmpty() || Boolean.parseBoolean(value);
        }
        return null;
    }

    private static Boolean booleanProperty(Properties sysProps, Properties userProps, String prop) {
        String value = sysProps.getProperty(prop);
        if (value == null) {
            value = userProps.getProperty(prop);
        }
        return value == null ? null : Boolean.valueOf(value.isEmpty() || Boolean.parseBoolean(value));
    }

    private static Path pathProperty(Properties sysProps, Properties userProps, String prop) {
        String value = sysProps.getProperty(prop);
        if (value == null) {
            value = userProps.getProperty(prop);
        }
        return value == null ? null : Path.of(value, new String[0]);
    }

    private static List<String> stringListProperty(Properties sysProps, Properties userProps, String prop) {
        String value = sysProps.getProperty(prop);
        if (value == null) {
            value = userProps.getProperty(prop);
        }
        if (value != null && value.isEmpty()) {
            return Arrays.stream(value.split(",")).collect(Collectors.toList());
        }
        return null;
    }

    static {
        EMPTY_PROPS = new Properties();
        EMPTY_CONFIG = new CacheConfig(null, null);
        CONFIG_CACHE = new WeakHashMap();
    }
}

