/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

class Diff {
    private final Object orig;
    private final Object actual;
    private final String path;

    Diff(Object orig, Object actual, String path) {
        if (orig == null && actual == null) {
            throw new IllegalArgumentException("Both orig and actual are {@code null}");
        }
        this.orig = orig;
        this.actual = actual;
        this.path = path;
    }

    String asString() {
        StringBuilder sb = new StringBuilder(this.path);
        if (this.orig != null && this.actual != null) {
            sb.append(" was '").append(this.orig).append("' but is now '").append(this.actual).append("'");
        } else if (this.actual != null) {
            sb.append(" has been added");
        } else {
            sb.append(" has been removed");
        }
        return sb.toString();
    }
}

