/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigConverter;
import io.helidon.build.cache.ConfigNode;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class ConfigConverters {
    private ConfigConverters() {
    }

    static Xpp3Dom toXpp3Dom(ConfigNode node) {
        return (Xpp3Dom)new Xpp3DomConverter(node).apply();
    }

    static String toString(ConfigNode node) {
        return (String)new StringAdapter(node).apply();
    }

    private static final class StringAdapter
    extends ConfigConverter<String> {
        private final StringBuilder sb = new StringBuilder();
        private final LinkedList<Integer> indexes = new LinkedList();

        StringAdapter(ConfigNode node) {
            super(node);
        }

        @Override
        void leafNode(ConfigNode node) {
            if (this.indexes.isEmpty()) {
                this.processNode(node, 0);
            } else {
                int index = this.indexes.pop();
                this.processNode(node, index);
                this.indexes.push(++index);
            }
        }

        @Override
        boolean enteringTreeNode(ConfigNode node) {
            int index = this.indexes.isEmpty() ? 0 : this.indexes.pop();
            this.processNode(node, index);
            this.indexes.push(++index);
            this.indexes.push(0);
            return true;
        }

        @Override
        void leavingTreeNode(ConfigNode node) {
            this.sb.append("]");
            this.indexes.pop();
        }

        void processNode(ConfigNode node, int index) {
            String value;
            if (index > 0) {
                this.sb.append(",");
            }
            this.sb.append(node.name());
            Map<String, String> attributes = node.attributes();
            if (!attributes.isEmpty()) {
                this.sb.append("<").append(attributes.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(","))).append(">");
            }
            if ((value = node.value()) != null && !value.isEmpty()) {
                this.sb.append("=").append(value);
            } else if (node.hasChildren()) {
                this.sb.append("[");
            }
        }

        @Override
        protected String root() {
            return this.sb.toString();
        }
    }

    private static final class Xpp3DomConverter
    extends ConfigConverter<Xpp3Dom> {
        private Xpp3Dom root = null;
        private Xpp3Dom parent = null;

        Xpp3DomConverter(ConfigNode node) {
            super(node);
        }

        @Override
        boolean enteringTreeNode(ConfigNode node) {
            this.processNode(node);
            return true;
        }

        @Override
        void leavingTreeNode(ConfigNode node) {
            if (this.parent != null) {
                this.parent = this.parent.getParent();
            }
        }

        @Override
        void leafNode(ConfigNode node) {
            this.processNode(node);
        }

        void processNode(ConfigNode node) {
            Xpp3Dom elt = new Xpp3Dom(node.name());
            node.attributes().forEach((arg_0, arg_1) -> ((Xpp3Dom)elt).setAttribute(arg_0, arg_1));
            elt.setValue(node.value());
            if (this.parent != null) {
                this.parent.addChild(elt);
            }
            if (node.hasChildren()) {
                this.parent = elt;
            }
            if (this.root == null) {
                this.root = elt;
            }
        }

        @Override
        protected Xpp3Dom root() {
            return this.root;
        }
    }
}

