/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.CacheArchiveIndex;
import io.helidon.build.cache.CacheConfig;
import io.helidon.build.util.SourcePath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=CacheArchiveManager.class, hint="default")
public class CacheArchiveManager {
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement
    private Logger logger;

    public void save(MavenSession session, Path archiveFile) {
        Archiver archiver;
        this.logger.info("Creating build cache archive...");
        try {
            archiver = this.archiverManager.getArchiver("tar");
        }
        catch (NoSuchArchiverException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            ArtifactRepository localRepository = session.getLocalRepository();
            Path localRepoDir = Path.of(localRepository.getBasedir(), new String[0]);
            Path projectRootDir = Path.of(session.getExecutionRootDirectory(), new String[0]);
            LinkedList<CacheArchiveIndex.ProjectEntry> projectEntries = new LinkedList<CacheArchiveIndex.ProjectEntry>();
            LinkedList<CacheArchiveIndex.FileEntry> repoFiles = new LinkedList<CacheArchiveIndex.FileEntry>();
            CacheArchiveIndex index = new CacheArchiveIndex(projectEntries, repoFiles);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Collecting files...");
            }
            AtomicInteger fileIndex = new AtomicInteger();
            for (MavenProject project : session.getProjects()) {
                CacheConfig cacheConfig = CacheConfig.of(project, session);
                if (cacheConfig.skip()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug(String.format("[%s:%s] - cache.skip is true, not saving state", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                Path buildDir = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory());
                List<String> buildFilesExcludes = cacheConfig.buildFilesExcludes();
                LinkedList<CacheArchiveIndex.FileEntry> buildFiles = new LinkedList<CacheArchiveIndex.FileEntry>();
                if (Files.exists(buildDir, new LinkOption[0])) {
                    Files.walk(buildDir, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && !f.equals(archiveFile) && new SourcePath(buildDir, f).matches(null, (Collection)buildFilesExcludes)).forEach(f -> {
                        CacheArchiveIndex.FileEntry buildFile = new CacheArchiveIndex.FileEntry(buildDir.relativize((Path)f).toString(), fileIndex.getAndIncrement());
                        buildFiles.add(buildFile);
                        archiver.addFile(f.toFile(), buildFile.index());
                    });
                }
                projectEntries.add(new CacheArchiveIndex.ProjectEntry(project.getGroupId(), project.getArtifactId(), projectRootDir.relativize(buildDir).toString(), buildFiles));
                for (Artifact artifact : CacheArchiveManager.projectArtifacts(project)) {
                    for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                        if (!(metadata instanceof ProjectArtifactMetadata)) continue;
                        String repoPath = localRepository.pathOfLocalRepositoryMetadata(metadata, null);
                        CacheArchiveIndex.FileEntry repoFile = new CacheArchiveIndex.FileEntry(repoPath, fileIndex.getAndIncrement());
                        archiver.addFile(localRepoDir.resolve(repoPath).toFile(), repoFile.index());
                        repoFiles.add(repoFile);
                    }
                    String repoPath = localRepository.pathOf(artifact);
                    Path localRepoPath = localRepoDir.resolve(repoPath);
                    if (!Files.exists(localRepoPath, new LinkOption[0])) continue;
                    CacheArchiveIndex.FileEntry repoFile = new CacheArchiveIndex.FileEntry(repoPath, fileIndex.getAndIncrement());
                    archiver.addFile(localRepoDir.resolve(repoPath).toFile(), repoFile.index());
                    repoFiles.add(repoFile);
                }
            }
            int numBuildFiles = projectEntries.stream().map(p -> p.buildFiles().size()).mapToInt(Integer::intValue).sum();
            this.logger.info(String.format("Found %d build file(s)", numBuildFiles));
            this.logger.info(String.format("Found %d repository file(s)", repoFiles.size()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating cache index...");
            }
            Path indexPath = Files.createTempFile("cacheIndex", ".xml", new FileAttribute[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cache index file: " + indexPath);
            }
            index.save(indexPath);
            File indexFile = indexPath.toFile();
            indexFile.deleteOnExit();
            archiver.addFile(indexPath.toFile(), "index.xml");
            archiver.setDestFile(archiveFile.toFile());
            archiver.createArchive();
        }
        catch (IOException ex) {
            this.logger.error("An error occurred while creating build cache archive", (Throwable)ex);
        }
    }

    private CacheArchiveIndex load(Path cacheArchive) throws IOException, XmlPullParserException {
        PlexusIoResourceCollection resources;
        try {
            resources = this.archiverManager.getResourceCollection("tar");
        }
        catch (NoSuchArchiverException ex) {
            throw new IllegalStateException(ex);
        }
        if (resources instanceof AbstractPlexusIoArchiveResourceCollection) {
            ((AbstractPlexusIoArchiveResourceCollection)resources).setFile(cacheArchive.toFile());
        }
        for (PlexusIoResource resource : resources) {
            if (!resource.getName().equals("index.xml")) continue;
            return CacheArchiveIndex.load(resource.getContents());
        }
        return null;
    }

    public void loadCache(MavenSession session, Path archiveFile) {
        UnArchiver unArchiver;
        CacheArchiveIndex index;
        this.logger.info("Loading build cache from file...");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Loading index");
            }
            if ((index = this.load(archiveFile)) == null) {
                this.logger.error("Index not found");
                return;
            }
        }
        catch (IOException | XmlPullParserException ex) {
            this.logger.error("Error while loading the index", ex);
            return;
        }
        try {
            unArchiver = this.archiverManager.getUnArchiver("tar");
            unArchiver.setSourceFile(archiveFile.toFile());
        }
        catch (NoSuchArchiverException ex) {
            throw new IllegalStateException(ex);
        }
        HashMap<String, String> unArchiverEntries = new HashMap<String, String>();
        FileSelector[] fileSelectors = new FileSelector[]{fileInfo -> unArchiverEntries.containsKey(fileInfo.getName())};
        unArchiver.setFileSelectors(fileSelectors);
        FileMapper[] fileMapperArray = new FileMapper[1];
        fileMapperArray[0] = unArchiverEntries::get;
        FileMapper[] fileMappers = fileMapperArray;
        unArchiver.setFileMappers(fileMappers);
        unArchiver.setOverwrite(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing repository files...");
        }
        Path localRepoDir = Path.of(session.getLocalRepository().getBasedir(), new String[0]);
        unArchiver.setDestDirectory(localRepoDir.toFile());
        unArchiver.setOverwrite(true);
        for (CacheArchiveIndex.FileEntry repoFile : index.repoFiles()) {
            unArchiverEntries.put(repoFile.index(), localRepoDir.resolve(repoFile.path()).toString());
        }
        unArchiver.extract();
        unArchiverEntries.clear();
        for (MavenProject project : session.getProjects()) {
            CacheArchiveIndex.ProjectEntry projectEntry = index.findProject(project.getGroupId(), project.getArtifactId());
            if (projectEntry == null) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.format("[%s:%s] - not found in index", project.getGroupId(), project.getArtifactId()));
                continue;
            }
            CacheConfig cacheConfig = CacheConfig.of(project, session);
            if (cacheConfig.skip()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.format("[%s:%s] - cache.skip is true, not loading state", project.getGroupId(), project.getArtifactId()));
                continue;
            }
            List<String> buildFilesExcludes = cacheConfig.buildFilesExcludes();
            Path buildDir = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory());
            for (CacheArchiveIndex.FileEntry buildFile : projectEntry.buildFiles()) {
                if (!new SourcePath(buildFile.path()).matches(null, buildFilesExcludes)) continue;
                unArchiverEntries.put(buildFile.index(), buildDir.resolve(buildFile.path()).toString());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing build files...");
        }
        unArchiver.setDestDirectory(new File(session.getExecutionRootDirectory()));
        unArchiver.setOverwrite(false);
        unArchiver.extract();
    }

    private static List<Artifact> projectArtifacts(MavenProject project) {
        LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
        Artifact artifact = project.getArtifact();
        if (artifact != null) {
            artifacts.add(artifact);
        }
        artifacts.addAll(project.getAttachedArtifacts());
        return artifacts;
    }
}

