/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigDiffs;
import io.helidon.build.cache.ExecutionEntry;

public final class ExecutionStatus {
    static final int STATE_CACHED = 0;
    static final int STATE_NEW = 1;
    static final int STATE_DIFF = 2;
    private final int code;
    private final ExecutionEntry execution;
    private final ConfigDiffs diffs;
    private static final String[] STATES_DESC = new String[]{"Cached", "New  ", "Diff  "};

    ExecutionStatus(int code, ExecutionEntry execution, ConfigDiffs diffs) {
        if (code > 2) {
            throw new IllegalArgumentException("Invalid state: " + code);
        }
        this.code = code;
        this.execution = execution;
        this.diffs = diffs;
    }

    public boolean isNew() {
        return this.code == 1;
    }

    public boolean isDiff() {
        return this.code == 2;
    }

    public boolean isCached() {
        return this.code == 0;
    }

    public ConfigDiffs diffs() {
        return this.diffs;
    }

    public ExecutionEntry execution() {
        return this.execution;
    }

    public String toString() {
        return STATES_DESC[this.code] + " | " + this.execution.name();
    }
}

