/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigNode;
import io.helidon.build.cache.Diff;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class ConfigDiffs
implements Iterator<Diff> {
    private final ConfigNode orig;
    private final ConfigNode actual;
    private final LinkedList<Item> stack;
    private boolean used;
    private Diff next;

    ConfigDiffs(ConfigNode orig, ConfigNode actual) {
        if (orig == null || actual == null) {
            throw new IllegalArgumentException();
        }
        this.orig = orig;
        this.actual = actual;
        this.stack = new LinkedList();
        this.stack.add(new NodeItem(orig, actual));
    }

    ConfigDiffs rewind() {
        if (this.used) {
            this.stack.clear();
            this.stack.add(new NodeItem(this.orig, this.actual));
            this.used = false;
        }
        return this;
    }

    Stream<Diff> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }

    @Override
    public Diff next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.used = true;
        Diff diff = this.next;
        this.next = null;
        return diff;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && !this.stack.isEmpty()) {
            Item item = this.stack.pop();
            if (item instanceof NodeItem) {
                NodeItem node = (NodeItem)item;
                this.next = item.toDiff();
                if (this.next != null) continue;
                this.stack.addAll(0, node.attributes());
                List<NodeItem> children = node.children();
                if (children.isEmpty()) continue;
                for (int i = children.size() - 1; i >= 0; --i) {
                    this.stack.push(children.get(i));
                }
                continue;
            }
            this.next = item.toDiff();
        }
        return this.next != null;
    }

    private final class AttributeItem
    implements Item {
        private final NodeItem node;
        private final String key;
        private final String origValue;
        private final String actualValue;

        AttributeItem(NodeItem node, String key, String origValue, String actualValue) {
            if (node == null || key == null || key.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (origValue == null && actualValue == null) {
                throw new IllegalArgumentException();
            }
            this.node = node;
            this.key = key;
            this.origValue = origValue;
            this.actualValue = actualValue;
        }

        private String path() {
            ConfigNode n = this.node.orig != null ? this.node.orig : this.node.actual;
            Object path = n.path();
            if (n.parent() != null) {
                path = (String)path + "/";
            }
            return (String)path + n.name() + "{" + n.index() + "}#" + this.key;
        }

        @Override
        public Diff toDiff() {
            if (this.origValue == null || !this.origValue.equals(this.actualValue)) {
                return new Diff(this.origValue, this.actualValue, this.path());
            }
            return null;
        }
    }

    private final class NodeItem
    implements Item {
        private final ConfigNode orig;
        private final ConfigNode actual;

        NodeItem(ConfigNode orig, ConfigNode actual) {
            if (orig == null && actual == null) {
                throw new IllegalArgumentException();
            }
            this.orig = orig;
            this.actual = actual;
        }

        List<AttributeItem> attributes() {
            Map<String, String> origAttrs = this.orig.attributes();
            Map<String, String> actualAttrs = this.actual.attributes();
            LinkedList<AttributeItem> attributes = new LinkedList<AttributeItem>();
            for (Map.Entry<String, String> entry : origAttrs.entrySet()) {
                attributes.add(new AttributeItem(this, entry.getKey(), entry.getValue(), actualAttrs.getOrDefault(entry.getKey(), null)));
            }
            for (Map.Entry<String, String> entry : actualAttrs.entrySet()) {
                if (origAttrs.containsKey(entry.getKey())) continue;
                attributes.add(new AttributeItem(this, entry.getKey(), null, entry.getValue()));
            }
            return attributes;
        }

        List<NodeItem> children() {
            Iterator<ConfigNode> origIt = this.orig.children().iterator();
            Iterator<ConfigNode> actualIt = this.actual.children().iterator();
            LinkedList<NodeItem> children = new LinkedList<NodeItem>();
            while (origIt.hasNext() || actualIt.hasNext()) {
                ConfigNode origNext = origIt.hasNext() ? origIt.next() : null;
                ConfigNode actualNext = actualIt.hasNext() ? actualIt.next() : null;
                children.add(new NodeItem(origNext, actualNext));
            }
            return children;
        }

        @Override
        public Diff toDiff() {
            if (this.orig != null && this.actual == null) {
                return new Diff(this.orig, null, this.orig.path());
            }
            if (this.orig == null && this.actual != null) {
                return new Diff(null, this.actual, this.actual.path());
            }
            if (this.orig != null) {
                if (!this.orig.name().equals(this.actual.name())) {
                    return new Diff(this.orig, this.actual, this.orig.path());
                }
                String origValue = this.orig.value();
                String actualValue = this.actual.value();
                if (origValue != null && actualValue == null && !this.actual.hasChildren() || origValue == null && actualValue != null && !this.orig.hasChildren() || origValue != null && actualValue != null && !origValue.equals(actualValue)) {
                    return new Diff(origValue, actualValue, this.orig.path() + "/" + this.orig.name());
                }
            }
            return null;
        }
    }

    private static interface Item {
        public Diff toDiff();
    }
}

