/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigAdapters;
import io.helidon.build.cache.ConfigNode;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class ArtifactEntry {
    static final String XML_ELEMENT_NAME = "artifact";
    private final String extension;
    private final String classifier;
    private final String file;
    private final boolean includesDependencies;
    private final String language;
    private final boolean addedToClasspath;

    ArtifactEntry(String file, String extension, String classifier, String language, boolean includesDependencies, boolean addedToClasspath) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
        this.classifier = classifier != null && classifier.isEmpty() ? null : classifier;
        this.file = Objects.requireNonNull(file, "file is null");
        this.language = language != null && language.isEmpty() ? null : language;
        this.includesDependencies = includesDependencies;
        this.addedToClasspath = addedToClasspath;
    }

    String file() {
        return this.file;
    }

    String classifier() {
        return this.classifier;
    }

    String extension() {
        return this.extension;
    }

    String language() {
        return this.language;
    }

    boolean addedToClasspath() {
        return this.addedToClasspath;
    }

    boolean includesDependencies() {
        return this.includesDependencies;
    }

    static ArtifactEntry create(Artifact artifact, MavenProject project) {
        if (artifact == null || artifact.getFile() == null) {
            return null;
        }
        ArtifactHandler handler = artifact.getArtifactHandler();
        String file = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).relativize(artifact.getFile().toPath()).toString();
        return new ArtifactEntry(file, artifact.getType(), artifact.getClassifier(), handler.getLanguage(), handler.isIncludesDependencies(), handler.isAddedToClasspath());
    }

    Artifact toArtifact(MavenProject project) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler(this.extension);
        if (this.language != null) {
            handler.setLanguage(this.language);
        }
        handler.setIncludesDependencies(this.includesDependencies);
        handler.setAddedToClasspath(this.addedToClasspath);
        DefaultArtifact artifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "compile", this.extension, this.classifier, (ArtifactHandler)handler);
        artifact.setFile(project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).resolve(this.file).toFile());
        return artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactEntry that = (ArtifactEntry)o;
        return this.includesDependencies == that.includesDependencies && this.addedToClasspath == that.addedToClasspath && Objects.equals(this.extension, that.extension) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.file, that.file) && Objects.equals(this.language, that.language);
    }

    public int hashCode() {
        return Objects.hash(this.extension, this.classifier, this.file, this.includesDependencies, this.language, this.addedToClasspath);
    }

    static ArtifactEntry fromXml(Xpp3Dom elt) {
        ConfigNode config = new ConfigNode(ConfigAdapters.create(elt), null);
        config.attributes().clear();
        return new ArtifactEntry(elt.getAttribute("file"), elt.getAttribute("extension"), elt.getAttribute("classifier"), elt.getAttribute("language"), Boolean.parseBoolean(elt.getAttribute("includesDependencies")), Boolean.parseBoolean(elt.getAttribute("addedToClasspath")));
    }

    Xpp3Dom toXml() {
        Xpp3Dom elt = new Xpp3Dom(XML_ELEMENT_NAME);
        elt.setAttribute("file", this.file);
        if (this.extension != null && !this.extension.isEmpty()) {
            elt.setAttribute("extension", this.extension);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            elt.setAttribute("classifier", this.classifier);
        }
        if (this.language != null && !this.language.isEmpty()) {
            elt.setAttribute("language", this.language);
        }
        elt.setAttribute("includesDependencies", Boolean.toString(this.includesDependencies));
        elt.setAttribute("addedToClasspath", Boolean.toString(this.addedToClasspath));
        return elt;
    }

    public String toString() {
        return "ArtifactEntry{extension='" + (this.extension == null ? "" : this.extension) + "', classifier='" + (this.classifier == null ? "" : this.classifier) + "', file='" + this.file + "', includesDependencies=" + this.includesDependencies + ", language='" + (this.language == null ? "" : this.language) + "', addedToClasspath=" + this.addedToClasspath + "}";
    }
}

