/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigNode;
import java.util.LinkedList;
import java.util.List;

abstract class ConfigVisitor {
    ConfigVisitor() {
    }

    boolean enteringTreeNode(ConfigNode node) {
        return true;
    }

    void leavingTreeNode(ConfigNode node) {
    }

    abstract void leafNode(ConfigNode var1);

    final void visit(ConfigNode node) {
        int parentId;
        LinkedList<ConfigNode> stack = new LinkedList<ConfigNode>();
        stack.push(node);
        ConfigNode parent = node.parent();
        int n = parentId = parent != null ? parent.id() : 0;
        while (!stack.isEmpty()) {
            node = (ConfigNode)stack.peek();
            parent = node.parent();
            if (node.id() == parentId) {
                parentId = parent != null ? parent.id() : 0;
                stack.pop();
                this.leavingTreeNode(node);
                continue;
            }
            List<ConfigNode> children = node.children();
            if (!children.isEmpty()) {
                if (!this.enteringTreeNode(node)) continue;
                for (int i = children.size() - 1; i >= 0; --i) {
                    stack.push(children.get(i));
                }
                continue;
            }
            parentId = parent != null ? parent.id() : 0;
            stack.pop();
            this.leafNode(node);
        }
    }
}

