/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ArtifactEntry;
import io.helidon.build.cache.ExecutionEntry;
import io.helidon.build.cache.ProjectFiles;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class ProjectState {
    static final String STATE_FILE_NAME = "state.xml";
    private final Properties properties;
    private final ArtifactEntry artifact;
    private final List<ArtifactEntry> attachedArtifacts;
    private final List<String> compileSourceRoots;
    private final List<String> testCompileSourceRoots;
    private final ProjectFiles projectFiles;
    private final List<ExecutionEntry> executions;
    private final Map<ExecutionEntry, Optional<ExecutionEntry>> executionMatches;

    private ProjectState(Properties properties, ArtifactEntry artifact, List<ArtifactEntry> attachedArtifacts, List<String> compileSourceRoots, List<String> testCompileSourceRoots, ProjectFiles projectFiles, List<ExecutionEntry> executions) {
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.artifact = artifact;
        this.attachedArtifacts = attachedArtifacts == null ? List.of() : attachedArtifacts;
        this.compileSourceRoots = compileSourceRoots == null ? List.of() : compileSourceRoots;
        this.testCompileSourceRoots = testCompileSourceRoots == null ? List.of() : testCompileSourceRoots;
        this.projectFiles = Objects.requireNonNull(projectFiles, "projectFiles is null");
        this.executions = executions == null ? List.of() : executions;
        this.executionMatches = new HashMap<ExecutionEntry, Optional<ExecutionEntry>>();
    }

    ProjectFiles projectFiles() {
        return this.projectFiles;
    }

    static ProjectState load(MavenProject project) throws IOException, XmlPullParserException {
        Path stateFile = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).resolve(STATE_FILE_NAME);
        if (!Files.exists(stateFile, new LinkOption[0])) {
            return null;
        }
        BufferedReader reader = Files.newBufferedReader(stateFile);
        Xpp3Dom rootElt = Xpp3DomBuilder.build((Reader)reader, (boolean)false);
        Properties properties = new Properties();
        Xpp3Dom propertiesElt = rootElt.getChild("properties");
        if (propertiesElt != null) {
            for (Xpp3Dom propertyElt : propertiesElt.getChildren("property")) {
                Xpp3Dom[] name = propertyElt.getAttribute("name");
                String value = propertyElt.getAttribute("value");
                if (name == null || name.isEmpty() || value == null) continue;
                properties.setProperty((String)name, value);
            }
        }
        ArtifactEntry artifact = null;
        Xpp3Dom artifactElt = rootElt.getChild("artifact");
        if (artifactElt != null) {
            artifact = ArtifactEntry.fromXml(artifactElt);
        }
        LinkedList<ArtifactEntry> attachedArtifacts = new LinkedList<ArtifactEntry>();
        Xpp3Dom attachedArtifactsElt = rootElt.getChild("attached-artifacts");
        if (attachedArtifactsElt != null) {
            for (Xpp3Dom attachedArtifactElt : attachedArtifactsElt.getChildren("artifact")) {
                attachedArtifacts.add(ArtifactEntry.fromXml(attachedArtifactElt));
            }
        }
        LinkedList<String> compileSourceRoots = new LinkedList<String>();
        Xpp3Dom compileSourceRootsElt = rootElt.getChild("compile-source-roots");
        if (compileSourceRootsElt != null) {
            for (Xpp3Dom pathElt : compileSourceRootsElt.getChildren("path")) {
                String path = pathElt.getValue();
                if (path == null || path.isEmpty()) continue;
                compileSourceRoots.add(path);
            }
        }
        LinkedList<String> testCompileSourceRoots = new LinkedList<String>();
        Xpp3Dom testCompileSourceRootsElt = rootElt.getChild("test-compile-source-roots");
        if (testCompileSourceRootsElt != null) {
            for (Xpp3Dom pathElt : testCompileSourceRootsElt.getChildren("path")) {
                String path = pathElt.getValue();
                if (path == null || path.isEmpty()) continue;
                testCompileSourceRoots.add(path);
            }
        }
        ProjectFiles projectFiles = ProjectFiles.fromXml(rootElt.getChild("project-files"));
        LinkedList<ExecutionEntry> executions = new LinkedList<ExecutionEntry>();
        Xpp3Dom executionsElt = rootElt.getChild("executions");
        if (executionsElt != null) {
            for (Xpp3Dom executionElt : executionsElt.getChildren("execution")) {
                executions.add(ExecutionEntry.fromXml(executionElt));
            }
        }
        return new ProjectState(properties, artifact, attachedArtifacts, compileSourceRoots, testCompileSourceRoots, projectFiles, executions);
    }

    void save(MavenProject project) throws IOException {
        Path buildDir = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory());
        Xpp3Dom rootElt = new Xpp3Dom("project-state");
        Xpp3Dom propertiesElt = new Xpp3Dom("properties");
        for (String string : this.properties.stringPropertyNames()) {
            Xpp3Dom xpp3Dom = new Xpp3Dom("property");
            xpp3Dom.setAttribute("name", string);
            xpp3Dom.setAttribute("value", this.properties.getProperty(string));
            propertiesElt.addChild(xpp3Dom);
        }
        rootElt.addChild(propertiesElt);
        if (this.artifact != null) {
            rootElt.addChild(this.artifact.toXml());
        }
        Xpp3Dom attachedArtifactsElt = new Xpp3Dom("attached-artifacts");
        for (ArtifactEntry artifactEntry : this.attachedArtifacts) {
            attachedArtifactsElt.addChild(artifactEntry.toXml());
        }
        rootElt.addChild(attachedArtifactsElt);
        Xpp3Dom xpp3Dom = new Xpp3Dom("compile-source-roots");
        for (String string : this.compileSourceRoots) {
            Xpp3Dom xpp3Dom2 = new Xpp3Dom("path");
            xpp3Dom2.setValue(string);
            xpp3Dom.addChild(xpp3Dom2);
        }
        rootElt.addChild(xpp3Dom);
        Xpp3Dom xpp3Dom3 = new Xpp3Dom("test-compile-source-roots");
        for (String string : this.testCompileSourceRoots) {
            Xpp3Dom pathElt = new Xpp3Dom("path");
            pathElt.setValue(string);
            xpp3Dom3.addChild(pathElt);
        }
        rootElt.addChild(xpp3Dom3);
        rootElt.addChild(this.projectFiles.toXml());
        Xpp3Dom xpp3Dom4 = new Xpp3Dom("executions");
        for (ExecutionEntry execution : this.executions) {
            xpp3Dom4.addChild(execution.toXml());
        }
        rootElt.addChild(xpp3Dom4);
        if (!Files.exists(buildDir, new LinkOption[0])) {
            Files.createDirectories(buildDir, new FileAttribute[0]);
        }
        FileWriter fileWriter = new FileWriter(buildDir.resolve(STATE_FILE_NAME).toFile());
        Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)rootElt);
        fileWriter.flush();
        fileWriter.close();
    }

    void apply(MavenProject project, MavenSession session) {
        Path projectDir = project.getModel().getProjectDirectory().toPath();
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> project.getProperties().put(k, ProjectState.loadPropValue(session, (String)v))));
        Optional.ofNullable(this.artifact).map(a -> a.toArtifact(project)).ifPresent(arg_0 -> ((MavenProject)project).setArtifact(arg_0));
        this.compileSourceRoots.stream().map(projectDir::resolve).map(Object::toString).filter(project.getCompileSourceRoots()::contains).forEach(arg_0 -> ((MavenProject)project).addCompileSourceRoot(arg_0));
        this.testCompileSourceRoots.stream().map(projectDir::resolve).map(Object::toString).filter(project.getTestCompileSourceRoots()::contains).forEach(arg_0 -> ((MavenProject)project).addTestCompileSourceRoot(arg_0));
        this.attachedArtifacts.stream().map(a -> a.toArtifact(project)).forEach(arg_0 -> ((MavenProject)project).addAttachedArtifact(arg_0));
    }

    boolean hasMatchingExecution(ExecutionEntry execution) {
        return this.findMatchingExecution(execution) != null;
    }

    ExecutionEntry findMatchingExecution(ExecutionEntry execution) {
        return this.executionMatches.computeIfAbsent(execution, key -> {
            for (ExecutionEntry exec : this.executions) {
                if (!exec.matches((ExecutionEntry)key)) continue;
                return Optional.of(exec);
            }
            return Optional.empty();
        }).orElse(null);
    }

    static ProjectState merge(ProjectState state, MavenProject project, MavenSession session, List<ExecutionEntry> newExecutions, ProjectFiles newProjectFiles) throws IOException {
        Properties properties;
        List<Object> executions;
        Path projectDir = project.getModel().getProjectDirectory().toPath();
        if (state == null) {
            executions = List.of();
            properties = new Properties();
        } else {
            executions = state.executions;
            properties = state.properties;
        }
        Properties projectProps = new Properties();
        project.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> projectProps.put(k, ProjectState.savePropValue(session, (String)v))));
        return new ProjectState(ProjectState.mergeProperties(properties, projectProps), Optional.ofNullable(project.getArtifact()).map(a -> ArtifactEntry.create(a, project)).orElse(null), project.getAttachedArtifacts().stream().map(a -> ArtifactEntry.create(a, project)).collect(Collectors.toList()), project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(projectDir::relativize).map(Path::toString).collect(Collectors.toList()), project.getTestCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(projectDir::relativize).map(Path::toString).collect(Collectors.toList()), newProjectFiles == null ? ProjectFiles.of(project, session) : newProjectFiles, Stream.concat(executions.stream().filter(exec -> newExecutions.stream().noneMatch(exec::matches)), newExecutions.stream()).collect(Collectors.toList()));
    }

    private static String loadPropValue(MavenSession session, String value) {
        return value.replace("#{exec.root.dir}", session.getExecutionRootDirectory());
    }

    private static String savePropValue(MavenSession session, String value) {
        return value.replace(session.getExecutionRootDirectory(), "#{exec.root.dir}");
    }

    private static Properties mergeProperties(Properties props1, Properties props2) {
        Properties properties = new Properties();
        props1.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        props2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        return properties;
    }
}

