/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class CacheArchiveIndex {
    private final List<ProjectEntry> projects;
    private final List<FileEntry> repoFiles;

    CacheArchiveIndex(List<ProjectEntry> projects, List<FileEntry> repoFiles) {
        this.projects = projects;
        this.repoFiles = repoFiles == null ? List.of() : repoFiles;
    }

    List<FileEntry> repoFiles() {
        return this.repoFiles;
    }

    ProjectEntry findProject(String groupId, String artifactId) {
        return this.projects.stream().filter(p -> p.groupId.equals(groupId) && p.artifactId.equals(artifactId)).findAny().orElse(null);
    }

    void save(Path file) throws IOException {
        Xpp3Dom rootElt = this.toXml();
        FileWriter writer = new FileWriter(file.toFile());
        Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)rootElt);
        writer.flush();
        writer.close();
    }

    Xpp3Dom toXml() {
        Xpp3Dom rootElt = new Xpp3Dom("build-cache");
        Xpp3Dom repoFilesElt = new Xpp3Dom("repository");
        for (FileEntry repoFile : this.repoFiles) {
            Xpp3Dom repoFileElt = new Xpp3Dom("file");
            repoFileElt.setValue(String.valueOf(repoFile.index));
            repoFileElt.setAttribute("path", repoFile.path);
            repoFilesElt.addChild(repoFileElt);
        }
        rootElt.addChild(repoFilesElt);
        Xpp3Dom projectsElt = new Xpp3Dom("projects");
        for (ProjectEntry project : this.projects) {
            Xpp3Dom projectElt = new Xpp3Dom("project");
            projectElt.setAttribute("groupId", project.groupId);
            projectElt.setAttribute("artifactId", project.artifactId);
            projectElt.setAttribute("path", project.path);
            Xpp3Dom buildFilesElt = new Xpp3Dom("build");
            for (FileEntry buildFile : project.buildFiles) {
                Xpp3Dom buildFileElt = new Xpp3Dom("file");
                buildFileElt.setValue(String.valueOf(buildFile.index));
                buildFileElt.setAttribute("path", buildFile.path);
                buildFilesElt.addChild(buildFileElt);
            }
            projectElt.addChild(buildFilesElt);
            projectsElt.addChild(projectElt);
        }
        rootElt.addChild(projectsElt);
        return rootElt;
    }

    static CacheArchiveIndex load(InputStream is) throws IOException, XmlPullParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
        Xpp3Dom rootElt = Xpp3DomBuilder.build((Reader)reader);
        reader.close();
        LinkedList<ProjectEntry> projects = new LinkedList<ProjectEntry>();
        Xpp3Dom projectsElt = rootElt.getChild("projects");
        for (Xpp3Dom projectElt : projectsElt.getChildren("project")) {
            LinkedList<FileEntry> buildFiles = new LinkedList<FileEntry>();
            Xpp3Dom buildFilesElt = projectElt.getChild("build");
            if (buildFilesElt != null) {
                for (Xpp3Dom fileElt : buildFilesElt.getChildren("file")) {
                    String index = fileElt.getValue();
                    String path = fileElt.getAttribute("path");
                    if (index == null || index.isEmpty() || path == null || path.isEmpty()) continue;
                    buildFiles.add(new FileEntry(path, index));
                }
            }
            projects.add(new ProjectEntry(projectElt.getAttribute("groupId"), projectElt.getAttribute("artifactId"), projectElt.getAttribute("path"), buildFiles));
        }
        LinkedList<FileEntry> repoFiles = new LinkedList<FileEntry>();
        Xpp3Dom repositoryElt = rootElt.getChild("repository");
        for (Xpp3Dom fileElt : repositoryElt.getChildren("file")) {
            String index = fileElt.getValue();
            String path = fileElt.getAttribute("path");
            if (index == null || index.isEmpty() || path == null || path.isEmpty()) continue;
            repoFiles.add(new FileEntry(path, index));
        }
        return new CacheArchiveIndex(projects, repoFiles);
    }

    static final class FileEntry {
        private final String path;
        private final String index;

        FileEntry(String path, String index) {
            this.path = path;
            this.index = index;
        }

        FileEntry(String path, int index) {
            this(path, Integer.toString(index));
        }

        String path() {
            return this.path;
        }

        String index() {
            return this.index;
        }
    }

    static final class ProjectEntry {
        private final String groupId;
        private final String artifactId;
        private final String path;
        private final List<FileEntry> buildFiles;

        ProjectEntry(String groupId, String artifactId, String path, List<FileEntry> buildFiles) {
            this.groupId = Objects.requireNonNull(groupId, "groupId is null");
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId is null");
            this.path = Objects.requireNonNull(path, "path is null");
            this.buildFiles = buildFiles == null ? List.of() : buildFiles;
        }

        List<FileEntry> buildFiles() {
            return this.buildFiles;
        }
    }
}

