/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ProjectFiles;
import io.helidon.build.cache.ProjectState;

final class ProjectStateStatus {
    static final int STATE_VALID = 0;
    static final int STATE_UNAVAILABLE = 1;
    static final int STATE_FILES_CHANGED = 2;
    static final int STATE_INVALID_DOWNSTREAM = 3;
    static final ProjectStateStatus UNAVAILABLE = new ProjectStateStatus(1, null, null);
    private final int code;
    private final ProjectState state;
    private final ProjectFiles projectFiles;

    ProjectStateStatus(int code, ProjectState state, ProjectFiles projectFiles) {
        this.code = code;
        this.state = state;
        this.projectFiles = projectFiles;
    }

    int code() {
        return this.code;
    }

    ProjectFiles projectFiles() {
        return this.projectFiles;
    }

    ProjectStateStatus invalidate() {
        return new ProjectStateStatus(3, this.state, this.projectFiles);
    }

    ProjectState state() throws IllegalStateException {
        return this.state;
    }
}

