/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache;

import io.helidon.build.cache.ConfigAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class ConfigAdapters {
    private ConfigAdapters() {
    }

    static ConfigAdapter create(Xpp3Dom orig) {
        return new Xpp3DomAdapter(orig);
    }

    static ConfigAdapter create(PlexusConfiguration orig) {
        return new PlexusConfigurationAdapter(orig);
    }

    private static final class PlexusConfigurationAdapter
    implements ConfigAdapter {
        private final PlexusConfiguration orig;

        PlexusConfigurationAdapter(PlexusConfiguration orig) {
            this.orig = orig;
        }

        @Override
        public String name() {
            return this.orig.getName();
        }

        @Override
        public String value() {
            return this.orig.getValue();
        }

        @Override
        public Map<String, String> attributes() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String attrName : this.orig.getAttributeNames()) {
                attributes.put(attrName, this.orig.getAttribute(attrName));
            }
            return attributes;
        }

        @Override
        public List<ConfigAdapter> children() {
            return Arrays.stream(this.orig.getChildren()).map(PlexusConfigurationAdapter::new).collect(Collectors.toList());
        }
    }

    private static final class Xpp3DomAdapter
    implements ConfigAdapter {
        private final Xpp3Dom orig;

        Xpp3DomAdapter(Xpp3Dom orig) {
            this.orig = orig;
        }

        @Override
        public String name() {
            return this.orig.getName();
        }

        @Override
        public String value() {
            return this.orig.getValue();
        }

        @Override
        public Map<String, String> attributes() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String attrName : this.orig.getAttributeNames()) {
                attributes.put(attrName, this.orig.getAttribute(attrName));
            }
            return attributes;
        }

        @Override
        public List<ConfigAdapter> children() {
            return Arrays.stream(this.orig.getChildren()).map(Xpp3DomAdapter::new).collect(Collectors.toList());
        }
    }
}

