/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class ConsumerPrintStream
extends PrintStream {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final int LINE_FEED = 10;
    private static final int CARRIAGE_RETURN = 13;
    private static final int NONE = -1;
    private final ByteArrayOutputStream buffer;
    private final Consumer<String> consumer;
    private int last;

    public static ConsumerPrintStream newStream(Consumer<String> consumer) {
        try {
            return new ConsumerPrintStream(consumer);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private ConsumerPrintStream(Consumer<String> consumer) throws UnsupportedEncodingException {
        super((OutputStream)new ByteArrayOutputStream(), true, ENCODING.toString());
        this.buffer = (ByteArrayOutputStream)this.out;
        this.consumer = consumer;
        this.last = -1;
    }

    @Override
    public void write(int b) {
        if (this.last == 13 && b == 10) {
            this.last = -1;
        } else {
            if (b != 10 && b != 13) {
                super.write(b);
            } else {
                try {
                    this.consumer.accept(this.buffer.toString());
                }
                finally {
                    this.buffer.reset();
                }
            }
            this.last = b;
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        if (length >= 0) {
            for (int index = 0; index < length; ++index) {
                this.write(bytes[offset + index]);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(length);
        }
    }
}

