/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.maven;

import io.helidon.build.common.logging.Log;
import io.helidon.build.devloop.BuildRoot;
import io.helidon.build.devloop.BuildStep;
import io.helidon.build.devloop.maven.MavenEnvironment;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecution;

public class MavenGoal
implements BuildStep {
    private static final String DEFAULT_EXECUTION_ID_PREFIX = "default-";
    private final String name;
    private final String pluginKey;
    private final String executionId;
    private final MojoExecution execution;
    private final MavenEnvironment environment;

    public static MavenGoal create(String pluginGroupId, String pluginArtifactId, String goalName, String executionId, MavenEnvironment environment) {
        return new MavenGoal(Objects.requireNonNull(pluginGroupId), Objects.requireNonNull(pluginArtifactId), Objects.requireNonNull(goalName), (String)(executionId == null ? DEFAULT_EXECUTION_ID_PREFIX + goalName : executionId), Objects.requireNonNull(environment));
    }

    private MavenGoal(String pluginGroupId, String pluginArtifactId, String goalName, String executionId, MavenEnvironment environment) {
        this.name = goalName;
        this.pluginKey = pluginGroupId + ":" + pluginArtifactId;
        this.executionId = executionId;
        this.execution = environment.execution(this.pluginKey, goalName, executionId);
        this.environment = environment;
    }

    @Override
    public void incrementalBuild(BuildRoot.Changes changes, PrintStream stdOut, PrintStream stdErr) throws Exception {
        if (!changes.isEmpty()) {
            this.execute();
        }
    }

    public void execute() throws Exception {
        Log.debug((String)"Executing %s", (Object[])new Object[]{this});
        this.environment.execute(this.execution);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String pluginKey() {
        return this.pluginKey;
    }

    public String executionId() {
        return this.executionId;
    }

    public String toString() {
        return this.pluginKey() + ":" + this.name() + "@" + this.executionId();
    }
}

