/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.maven;

import io.helidon.build.devloop.BuildExecutor;
import io.helidon.build.devloop.BuildMonitor;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;

public class EmbeddedMavenExecutor
extends BuildExecutor {
    private static final AtomicReference<Object> MAVEN_CLI = new AtomicReference();
    private static final AtomicReference<Method> DO_MAIN_METHOD = new AtomicReference();
    private static final String MAVEN_CLI_CLASS_NAME = "org.apache.maven.cli.MavenCli";
    private static final String DO_MAIN_METHOD_NAME = "doMain";
    private final PrintStream out;
    private final PrintStream err;

    public EmbeddedMavenExecutor(Path projectDir, BuildMonitor monitor) {
        super(projectDir, monitor);
        EmbeddedMavenExecutor.initialize();
        this.out = monitor.stdOut();
        this.err = monitor.stdErr();
    }

    @Override
    public boolean willFork() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        Object mavenCli = MAVEN_CLI.get();
        Method doMain = DO_MAIN_METHOD.get();
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(mavenCli.getClass().getClassLoader());
        try {
            Object result = doMain.invoke(mavenCli, args, this.projectDirectory().toString(), this.out, this.err);
            int exitValue = ((Number)result).intValue();
            if (exitValue != 0) {
                throw new Exception("Build failed");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private static void initialize() {
        if (MAVEN_CLI.get() == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cliClass = loader.loadClass(MAVEN_CLI_CLASS_NAME);
                MAVEN_CLI.set(cliClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                Class[] parameterTypes = new Class[]{String[].class, String.class, PrintStream.class, PrintStream.class};
                DO_MAIN_METHOD.set(cliClass.getMethod(DO_MAIN_METHOD_NAME, parameterTypes));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

