/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop;

import io.helidon.build.common.PathFilters;
import io.helidon.build.devloop.DirectoryType;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiPredicate;

public class BuildRootType {
    private static final BiPredicate<Path, Path> JAVA_SOURCE = PathFilters.matchesFileNameSuffix((String)".java");
    private static final BiPredicate<Path, Path> JAVA_CLASS = PathFilters.matchesFileNameSuffix((String)".class");
    private static final BiPredicate<Path, Path> RESOURCE_FILE = (path, root) -> {
        String fileName = path.getFileName().toString();
        return !fileName.startsWith(".") && !fileName.endsWith(".class") && !fileName.endsWith(".swp") && !fileName.endsWith("~");
    };
    private static final BuildRootType JAVA_SOURCES = BuildRootType.create(DirectoryType.JavaSources, BuildRootType.matchesJavaSource());
    private static final BuildRootType JAVA_CLASSES = BuildRootType.create(DirectoryType.JavaClasses, BuildRootType.matchesJavaClass());
    private static final BuildRootType RESOURCES = BuildRootType.create(DirectoryType.Resources, BuildRootType.matchesResource());
    private final DirectoryType directoryType;
    private final BiPredicate<Path, Path> filter;

    public static BuildRootType javaSources() {
        return JAVA_SOURCES;
    }

    public static BuildRootType javaClasses() {
        return JAVA_CLASSES;
    }

    public static BuildRootType resources() {
        return RESOURCES;
    }

    public static BiPredicate<Path, Path> matchesJavaSource() {
        return JAVA_SOURCE;
    }

    public static BiPredicate<Path, Path> matchesJavaClass() {
        return JAVA_CLASS;
    }

    public static BiPredicate<Path, Path> matchesResource() {
        return RESOURCE_FILE;
    }

    public static BuildRootType create(DirectoryType directoryType, BiPredicate<Path, Path> filter) {
        return new BuildRootType(directoryType, filter);
    }

    private BuildRootType(DirectoryType directoryType, BiPredicate<Path, Path> filter) {
        this.directoryType = directoryType;
        this.filter = filter;
    }

    public DirectoryType directoryType() {
        return this.directoryType;
    }

    public BiPredicate<Path, Path> filter() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRootType that = (BuildRootType)o;
        return this.directoryType == that.directoryType && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.directoryType, this.filter});
    }

    public String toString() {
        return "BuildRootType{directoryType=" + this.directoryType + "}";
    }
}

