/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop;

import io.helidon.build.devloop.BuildFile;
import io.helidon.build.devloop.FileChangeAware;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BuildFiles
implements FileChangeAware {
    private final List<BuildFile> buildFiles;

    public BuildFiles(List<BuildFile> buildFiles) {
        if (Objects.requireNonNull(buildFiles).isEmpty()) {
            throw new IllegalArgumentException("empty");
        }
        this.buildFiles = Collections.unmodifiableList(buildFiles);
    }

    @Override
    public Optional<FileTime> changedTime() {
        return FileChangeAware.changedTimeOf(this.buildFiles);
    }

    public List<BuildFile> list() {
        return this.buildFiles;
    }
}

