/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.mode;

import io.helidon.build.common.JavaProcessBuilder;
import io.helidon.build.common.OSType;
import io.helidon.build.common.PrintStreams;
import io.helidon.build.common.ProcessMonitor;
import io.helidon.build.common.ansi.AnsiTextStyles;
import io.helidon.build.common.ansi.ConsoleUtils;
import io.helidon.build.devloop.Project;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectExecutor {
    private static final String JAVA_EXEC = OSType.currentOS().javaExecutable();
    private static final String JIT_LEVEL_ONE = "-XX:TieredStopAtLevel=1";
    private static final String JIT_TWO_COMPILER_THREADS = "-XX:CICompilerCount=2";
    private static final String STARTING = AnsiTextStyles.BoldBrightGreen.apply((Object)"starting");
    private static final String STOPPING = AnsiTextStyles.BoldYellow.apply((Object)"stopping");
    private static final String STOPPED = AnsiTextStyles.BoldBrightRed.apply((Object)"stopped");
    private static final long ERROR_MESSAGES_DONE_NANOS = 100000L;
    private static final List<String> EXIT_MESSAGE_FRAGMENTS = List.of("JDWP exit error", "BindException: Address already in use", "--enable-preview");
    private final Project project;
    private final String logPrefix;
    private final String name;
    private ProcessMonitor processMonitor;
    private final List<String> appJvmArgs;
    private final List<String> appArgs;
    private final StringBuilder stdErrBuf;
    private boolean hasExitMessage;
    private long lastErrorMessageTime;

    public ProjectExecutor(Project project, String logPrefix, List<String> appJvmArgs, List<String> appArgs) {
        this.project = project;
        this.logPrefix = logPrefix;
        this.name = AnsiTextStyles.BoldBrightCyan.apply((Object)project.name());
        this.appJvmArgs = appJvmArgs;
        this.appArgs = appArgs;
        this.stdErrBuf = new StringBuilder();
    }

    public Project project() {
        return this.project;
    }

    public void start() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(JAVA_EXEC);
        command.add(JIT_LEVEL_ONE);
        command.add(JIT_TWO_COMPILER_THREADS);
        command.add("-cp");
        command.add(this.classPathString());
        command.addAll(this.appJvmArgs);
        command.add(this.project.mainClassName());
        command.addAll(this.appArgs);
        this.start(command);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean verbose) {
        if (this.processMonitor != null) {
            if (verbose) {
                this.stateChanged(STOPPING);
            }
            try {
                this.processMonitor.stop();
            }
            finally {
                this.processMonitor = null;
            }
            if (verbose) {
                this.stateChanged(STOPPED);
            }
        }
    }

    public boolean isRunning() {
        return this.processMonitor != null && this.processMonitor.isAlive();
    }

    public boolean shouldExit() {
        if (this.hasExitMessage) {
            long elapsedNanos = System.nanoTime() - this.lastErrorMessageTime;
            return elapsedNanos > 100000L;
        }
        return false;
    }

    public boolean hasStdErrMessage() {
        return this.lastErrorMessageTime > 0L;
    }

    private void stateChanged(String state) {
        if (this.logPrefix == null) {
            PrintStreams.STDOUT.printf("%s %s", this.name, state);
        } else {
            PrintStreams.STDOUT.printf("%s%s %s", this.logPrefix, this.name, state);
        }
    }

    private void start(List<String> command) {
        this.lastErrorMessageTime = 0L;
        ProcessBuilder processBuilder = JavaProcessBuilder.newInstance().directory(this.project.root().path().toFile()).command(command);
        try {
            this.stateChanged(STARTING);
            PrintStreams.STDOUT.println();
            PrintStreams.STDOUT.flush();
            this.processMonitor = ProcessMonitor.builder().processBuilder(processBuilder).afterShutdown(ConsoleUtils::reset).stdOut(PrintStreams.STDOUT).stdErr(PrintStreams.delegate((PrintStream)PrintStreams.STDERR, this::printStdErr)).capture(true).build().start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void printStdErr(PrintStream stdErr, String str) {
        if (!str.endsWith("\n") || str.endsWith("\r")) {
            this.stdErrBuf.append(str);
        }
        String line = this.stdErrBuf.append(str).toString();
        this.stdErrBuf.setLength(0);
        this.lastErrorMessageTime = System.nanoTime();
        for (String exitMessageFragment : EXIT_MESSAGE_FRAGMENTS) {
            if (!line.contains(exitMessageFragment)) continue;
            this.hasExitMessage = true;
            break;
        }
        stdErr.print(str);
    }

    private String classPathString() {
        List paths = this.project.classpath().stream().map(File::getAbsolutePath).collect(Collectors.toList());
        return paths.stream().reduce("", (s1, s2) -> s1 + File.pathSeparator + s2);
    }
}

