/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.maven;

import io.helidon.build.common.Strings;
import io.helidon.build.devloop.maven.CurrentMavenSession;
import io.helidon.build.devloop.maven.MavenGoal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;

public class MavenEnvironment {
    private final MojoDescriptorCreator mojoDescriptorCreator;
    private final DefaultLifecycles defaultLifeCycles;
    private final LifecycleMappingDelegate standardLifecycleDelegate;
    private final Map<String, LifecycleMappingDelegate> lifecycleDelegates;
    private final BuildPluginManager pluginManager;
    private final MojoExecutor mojoExecutor;
    private final ProjectIndex projectIndex;

    public MavenEnvironment(MavenProject project, MavenSession session, MojoDescriptorCreator mojoDescriptorCreator, DefaultLifecycles defaultLifeCycles, LifecycleMappingDelegate standardLifecycleDelegate, Map<String, LifecycleMappingDelegate> lifecycleDelegates, BuildPluginManager buildPluginManager, MojoExecutor mojoExecutor) {
        session.setCurrentProject(project);
        CurrentMavenSession.initialize(session);
        this.projectIndex = new ProjectIndex(session.getProjects());
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.defaultLifeCycles = defaultLifeCycles;
        this.standardLifecycleDelegate = standardLifecycleDelegate;
        this.lifecycleDelegates = lifecycleDelegates;
        this.pluginManager = buildPluginManager;
        this.mojoExecutor = mojoExecutor;
    }

    public MavenProject project() {
        return this.session().getCurrentProject();
    }

    public MavenSession session() {
        return CurrentMavenSession.get();
    }

    public void execute(MojoExecution execution) {
        try {
            this.mojoExecutor.execute(this.session(), List.of(execution), this.projectIndex);
        }
        catch (LifecycleExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public MojoExecution execution(String pluginKey, String goal, String executionId) {
        MojoDescriptor mojoDescriptor;
        Plugin plugin = MavenEnvironment.plugin(this.project(), pluginKey);
        try {
            mojoDescriptor = this.mojoDescriptor(plugin, goal);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Xpp3Dom configuration = MavenEnvironment.configuration(plugin, executionId);
        return MavenEnvironment.mojoExecution(mojoDescriptor, executionId, configuration);
    }

    public MavenGoal goal(String prefix, String goal, String executionId) throws Exception {
        Plugin plugin = this.mojoDescriptorCreator.findPluginForPrefix(prefix, this.session());
        return MavenGoal.create(plugin.getGroupId(), plugin.getArtifactId(), goal, executionId, this);
    }

    public List<MavenGoal> phase(String phase) throws Exception {
        LifecycleMappingDelegate delegate = this.standardLifecycleDelegate;
        Lifecycle lifecycle = this.lifecycle(phase);
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) < 0 && (delegate = this.lifecycleDelegates.get(lifecycle.getId())) == null) {
            delegate = this.standardLifecycleDelegate;
        }
        return delegate.calculateLifecycleMappings(this.session(), this.project(), lifecycle, phase).entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> ((List)e.getValue()).stream()).map(this::goal).collect(Collectors.toList());
    }

    public Lifecycle lifecycle(String phase) throws Exception {
        DefaultLifecycles defaultLifecycles = this.defaultLifeCycles;
        Lifecycle lifecycle = defaultLifecycles.get(phase);
        if (lifecycle == null) {
            throw new LifecyclePhaseNotFoundException("Unknown lifecycle phase \"" + phase + "\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + defaultLifecycles.getLifecyclePhaseList() + ".", phase);
        }
        return lifecycle;
    }

    private MavenGoal goal(MojoExecution execution) {
        return MavenGoal.create(execution.getGroupId(), execution.getArtifactId(), execution.getGoal(), execution.getExecutionId(), this);
    }

    private static Plugin plugin(MavenProject project, String pluginKey) {
        PluginManagement pm;
        Plugin plugin = Objects.requireNonNull(project.getPlugin(pluginKey), "plugin " + pluginKey + " not found");
        if (Strings.isNotValid((String)plugin.getVersion()) && (pm = project.getPluginManagement()) != null) {
            for (Plugin p : pm.getPlugins()) {
                if (!plugin.getGroupId().equals(p.getGroupId()) || !plugin.getArtifactId().equals(p.getArtifactId())) continue;
                plugin.setVersion(p.getVersion());
                break;
            }
        }
        return plugin;
    }

    private MojoDescriptor mojoDescriptor(Plugin plugin, String goal) throws Exception {
        RepositorySystemSession repositorySession = this.session().getRepositorySession();
        List repositories = this.project().getRemotePluginRepositories();
        PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, repositories, repositorySession);
        return pluginDescriptor.getMojo(goal);
    }

    private static Xpp3Dom configuration(Plugin plugin, String executionId) {
        PluginExecution execution = (PluginExecution)plugin.getExecutionsAsMap().get(executionId);
        if (execution != null && execution.getConfiguration() != null) {
            return (Xpp3Dom)execution.getConfiguration();
        }
        if (plugin.getConfiguration() != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return new Xpp3Dom("configuration");
    }

    private static MojoExecution mojoExecution(MojoDescriptor mojoDescriptor, String executionId, Xpp3Dom executionConfig) {
        MojoExecution result = new MojoExecution(mojoDescriptor, executionId);
        Xpp3Dom configuration = MavenEnvironment.mojoConfiguration(mojoDescriptor, executionConfig);
        result.setConfiguration(configuration);
        return result;
    }

    private static Xpp3Dom mojoConfiguration(MojoDescriptor mojoDescriptor, Xpp3Dom executionConfiguration) {
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((String)(parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("implementation")) && StringUtils.isNotEmpty((String)parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        return finalConfiguration;
    }
}

