/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.maven;

import io.helidon.build.common.PathFilters;
import io.helidon.build.common.Strings;
import io.helidon.build.devloop.maven.MavenGoal;
import io.helidon.build.devloop.maven.MavenGoalReferenceResolver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;

public class DevLoopBuildConfig {
    private FullBuildConfig fullBuild = new FullBuildConfig();
    private IncrementalBuildConfig incrementalBuild = new IncrementalBuildConfig();
    private int maxApplicationFailures = Integer.MAX_VALUE;

    public void validate() throws MojoExecutionException {
        DevLoopBuildConfig.assertNonNull(this.fullBuild, "fullBuild required: " + this);
        DevLoopBuildConfig.assertNonNull(this.incrementalBuild, "incrementalBuild required: " + this);
        this.fullBuild.validate();
        this.incrementalBuild.validate();
        if (this.maxApplicationFailures < 0) {
            throw new MojoExecutionException("maxApplicationFailures cannot be negative: " + this);
        }
    }

    public void resolve(MavenGoalReferenceResolver resolver) throws Exception {
        this.fullBuild.resolve(resolver);
        this.incrementalBuild.resolve(resolver);
    }

    public FullBuildConfig fullBuild() {
        return this.fullBuild;
    }

    public IncrementalBuildConfig incrementalBuild() {
        return this.incrementalBuild;
    }

    public int maxApplicationFailures() {
        return this.maxApplicationFailures;
    }

    public void setFullBuild(FullBuildConfig fullBuild) {
        this.fullBuild = fullBuild;
    }

    public void setIncrementalBuild(IncrementalBuildConfig incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public void setMaxApplicationFailures(int maxApplicationFailures) {
        this.maxApplicationFailures = maxApplicationFailures;
    }

    public String toString() {
        return "devLoop {fullBuild=" + this.fullBuild + ", incrementalBuild=" + this.incrementalBuild + ", maxApplicationFailures=" + this.maxApplicationFailures + "}";
    }

    private static void assertNonNull(Object object, String errorMessage) throws MojoExecutionException {
        if (object == null) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    private static void assertNotEmpty(List<?> list, String errorMessage) throws MojoExecutionException {
        if (list == null || list.isEmpty()) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    private static <T> List<T> distinct(List<T> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }

    public static class FullBuildConfig {
        private static final String DEFAULT_FULL_BUILD_PHASE = "process-classes";
        private String phase = "process-classes";
        private int maxBuildFailures = Integer.MAX_VALUE;

        public void validate() throws MojoExecutionException {
            if (this.maxBuildFailures < 0) {
                throw new MojoExecutionException("maxBuildFailures cannot be negative: " + this);
            }
        }

        public void resolve(MavenGoalReferenceResolver resolver) throws Exception {
            resolver.assertValidPhase(this.phase);
        }

        public String phase() {
            return this.phase;
        }

        public int maxBuildFailures() {
            return this.maxBuildFailures;
        }

        public void setPhase(String phase) {
            this.phase = phase;
        }

        public void setMaxBuildFailures(int maxBuildFailures) {
            this.maxBuildFailures = maxBuildFailures;
        }

        public String toString() {
            return "fullBuild {phase='" + this.phase + "', maxBuildFailures=" + this.maxBuildFailures + "}";
        }
    }

    public static class IncrementalBuildConfig {
        private static final List<String> DEFAULT_RESOURCES_GOALS = List.of("resources:resources");
        private static final List<String> DEFAULT_JAVA_SOURCES_GOALS = List.of("compiler:compile");
        private List<String> unresolvedResourceGoals = DEFAULT_RESOURCES_GOALS;
        private List<String> unresolvedJavaSourceGoals = DEFAULT_JAVA_SOURCES_GOALS;
        private List<MavenGoal> resolvedResourceGoals;
        private List<MavenGoal> resolvedJavaSourceGoals;
        private List<CustomDirectoryConfig> customDirectories = Collections.emptyList();
        private int maxBuildFailures = Integer.MAX_VALUE;

        public void validate() throws MojoExecutionException {
            if (this.maxBuildFailures < 0) {
                throw new MojoExecutionException("maxBuildFailures cannot be negative: " + this);
            }
            DevLoopBuildConfig.assertNonNull(this.unresolvedResourceGoals, "resourceGoals cannot be null: " + this);
            DevLoopBuildConfig.assertNonNull(this.unresolvedJavaSourceGoals, "javaSourceGoals cannot be null: " + this);
            for (CustomDirectoryConfig custom : this.customDirectories) {
                custom.validate();
            }
        }

        public void resolve(MavenGoalReferenceResolver resolver) throws Exception {
            if (this.unresolvedResourceGoals.isEmpty()) {
                this.unresolvedResourceGoals = DEFAULT_RESOURCES_GOALS;
            }
            if (this.unresolvedJavaSourceGoals.isEmpty()) {
                this.unresolvedJavaSourceGoals = DEFAULT_JAVA_SOURCES_GOALS;
            }
            this.resolvedResourceGoals = resolver.resolve(this.unresolvedResourceGoals, new ArrayList<MavenGoal>());
            this.resolvedJavaSourceGoals = resolver.resolve(this.unresolvedJavaSourceGoals, new ArrayList<MavenGoal>());
            for (CustomDirectoryConfig directory : this.customDirectories()) {
                directory.resolve(resolver);
            }
        }

        public List<MavenGoal> resourceGoals() {
            return this.resolvedResourceGoals;
        }

        public List<MavenGoal> javaSourceGoals() {
            return this.resolvedJavaSourceGoals;
        }

        public List<String> unresolvedResourceGoals() {
            return this.unresolvedResourceGoals;
        }

        public List<String> unresolvedJavaSourceGoals() {
            return this.unresolvedJavaSourceGoals;
        }

        public List<CustomDirectoryConfig> customDirectories() {
            return this.customDirectories;
        }

        public int maxBuildFailures() {
            return this.maxBuildFailures;
        }

        public void setResourceGoals(List<String> resourceGoals) {
            this.unresolvedResourceGoals = DevLoopBuildConfig.distinct(resourceGoals);
        }

        public void setJavaSourceGoals(List<String> javaSourceGoals) {
            this.unresolvedJavaSourceGoals = DevLoopBuildConfig.distinct(javaSourceGoals);
        }

        public void setCustomDirectories(List<CustomDirectoryConfig> customDirectories) {
            this.customDirectories = DevLoopBuildConfig.distinct(customDirectories);
        }

        public void setMaxBuildFailures(int maxBuildFailures) {
            this.maxBuildFailures = maxBuildFailures;
        }

        public String toString() {
            return "incrementalBuild {resourceGoals=" + this.unresolvedResourceGoals + ", javaSourceGoals=" + this.unresolvedJavaSourceGoals + ", customDirectories=" + this.customDirectories + ", maxBuildFailures=" + this.maxBuildFailures + "}";
        }

        public static class CustomDirectoryConfig {
            private Path path;
            private String includes = "";
            private String excludes = "";
            private List<String> unresolvedGoals;
            private List<MavenGoal> resolvedGoals;
            private BiPredicate<Path, Path> mappedIncludes;

            public void validate() throws MojoExecutionException {
                DevLoopBuildConfig.assertNonNull(this.path, "path is required: " + this);
                DevLoopBuildConfig.assertNotEmpty(this.unresolvedGoals, "one or more goals are required: " + this);
                this.mappedIncludes = PathFilters.matches(CustomDirectoryConfig.toList(this.includes), CustomDirectoryConfig.toList(this.excludes));
                if (this.mappedIncludes == PathFilters.matchesNone()) {
                    throw new MojoExecutionException("includes + excludes will not match any file: " + this);
                }
            }

            public void resolve(MavenGoalReferenceResolver resolver) throws Exception {
                if (this.path.isAbsolute()) {
                    throw new IllegalArgumentException(this.path + " must be relative: " + this);
                }
                this.resolvedGoals = resolver.resolve(this.unresolvedGoals, new ArrayList<MavenGoal>());
            }

            private static List<String> toList(String list) {
                return Strings.isValid((String)list) ? Arrays.asList(list.split(",")) : Collections.emptyList();
            }

            public Path path() {
                return this.path;
            }

            public BiPredicate<Path, Path> includes() {
                return this.mappedIncludes;
            }

            public List<MavenGoal> goals() {
                return this.resolvedGoals;
            }

            public List<String> unresolvedGoals() {
                return this.unresolvedGoals;
            }

            public void setPath(String path) {
                this.path = Path.of(path, new String[0]);
            }

            public void setIncludes(String includes) {
                this.includes = includes;
            }

            public void setExcludes(String excludes) {
                this.excludes = excludes;
            }

            public void setGoals(List<String> goals) {
                this.unresolvedGoals = DevLoopBuildConfig.distinct(goals);
            }

            public String toString() {
                return "customDirectory {path='" + this.path + "', includes='" + this.includes + "', excludes='" + this.excludes + "', goals=" + this.unresolvedGoals + "}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CustomDirectoryConfig that = (CustomDirectoryConfig)o;
                return this.path.equals(that.path) && this.includes.equals(that.includes) && this.excludes.equals(that.excludes) && this.unresolvedGoals.equals(that.unresolvedGoals);
            }

            public int hashCode() {
                return Objects.hash(this.path, this.includes, this.excludes, this.unresolvedGoals);
            }
        }
    }
}

