/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop.maven;

import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

class CurrentMavenSession {
    private static final String MAVEN_SESSION_PROPERTY = "dev-loop:" + MavenSession.class.getName();
    private static final AtomicReference<MavenSession> CURRENT_SESSION = new AtomicReference();

    static void initialize(MavenSession session) {
        if (CURRENT_SESSION.get() == null) {
            CURRENT_SESSION.set(session);
        }
    }

    static void set(MavenSession session) {
        System.getProperties().put(MAVEN_SESSION_PROPERTY, Objects.requireNonNull(session));
    }

    static MavenSession get() {
        Properties systemProperties = System.getProperties();
        Object fullBuildSession = systemProperties.get(MAVEN_SESSION_PROPERTY);
        if (fullBuildSession != null) {
            MavenSession session = (MavenSession)fullBuildSession;
            session.setCurrentProject((MavenProject)session.getAllProjects().get(0));
            CURRENT_SESSION.set(session);
            systemProperties.remove(MAVEN_SESSION_PROPERTY);
            return session;
        }
        return CURRENT_SESSION.get();
    }

    private CurrentMavenSession() {
    }
}

