/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.devloop;

import io.helidon.build.common.PrintStreams;
import io.helidon.build.devloop.BuildType;
import io.helidon.build.devloop.ChangeType;
import io.helidon.build.devloop.Project;
import java.io.PrintStream;

public interface BuildMonitor {
    default public PrintStream stdOut() {
        return PrintStreams.STDOUT;
    }

    default public PrintStream stdErr() {
        return PrintStreams.STDERR;
    }

    public void onStarted();

    public void onCycleStart(int var1);

    public void onChanged(int var1, ChangeType var2);

    public void onBuildStart(int var1, BuildType var2);

    public void onBuildSuccess(int var1, BuildType var2);

    public long onBuildFail(int var1, BuildType var2, Throwable var3);

    public long onReady(int var1, Project var2);

    public NextAction onCycleEnd(int var1);

    public void onLoopFail(int var1, Throwable var2);

    public void onStopped();

    public static enum NextAction {
        CONTINUE,
        WAIT_FOR_CHANGE,
        EXIT;

    }
}

