/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.impl;

import io.hektor.fsm.Action;
import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.Guard;
import io.hektor.fsm.Transition;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TransitionImpl<E, S extends Enum<S>, C extends Context, D extends Data>
implements Transition<E, S, C, D> {
    private final String description;
    private final S to;
    private final Class<E> event;
    private final Predicate<E> guard;
    private final Guard<E, C, D> richerGuard;
    private final Optional<Consumer<E>> action;
    private final Optional<Action<E, C, D>> statefulAction;

    public TransitionImpl(String description, S to, Class<E> event, Predicate<E> guard, Guard<E, C, D> richerGuard, Consumer<E> action, Action<E, C, D> statefulAction) {
        this.description = description;
        this.to = to;
        this.event = event;
        this.guard = guard;
        this.richerGuard = richerGuard;
        this.action = Optional.ofNullable(action);
        this.statefulAction = Optional.ofNullable(statefulAction);
    }

    @Override
    public boolean match(Object event, C ctx, D data) {
        if (!this.event.isAssignableFrom(event.getClass())) {
            return false;
        }
        if (this.guard != null) {
            return this.guard.test(event);
        }
        if (this.richerGuard != null) {
            return this.richerGuard.test(event, ctx, data);
        }
        return true;
    }

    @Override
    public S getToState() {
        return this.to;
    }

    @Override
    public Optional<Consumer<E>> getAction() {
        return this.action;
    }

    @Override
    public Optional<Action<E, C, D>> getStatefulAction() {
        return this.statefulAction;
    }
}

