/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.impl;

import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.State;
import io.hektor.fsm.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

public class StateImpl<S extends Enum<S>, C extends Context, D extends Data>
implements State<S, C, D> {
    private final S state;
    private final boolean isInitial;
    private final boolean isFinal;
    private final boolean isTransient;
    private final List<Transition<?, S, C, D>> transitions;
    private final Optional<Transition<?, S, C, D>> defaultTransition;
    private final Optional<BiConsumer<C, D>> enterAction;
    private final Optional<BiConsumer<C, D>> exitAction;
    private final List<S> connectedNodes = new ArrayList<S>();

    public StateImpl(S state, boolean isInitial, boolean isFinal, boolean isTransient, List<Transition<?, S, C, D>> transitions, Optional<Transition<?, S, C, D>> defaultTransition, BiConsumer<C, D> enterAction, BiConsumer<C, D> exitAction) {
        this.state = state;
        this.isInitial = isInitial;
        this.isFinal = isFinal;
        this.isTransient = isTransient;
        this.transitions = transitions;
        this.defaultTransition = defaultTransition;
        this.enterAction = Optional.ofNullable(enterAction);
        this.exitAction = Optional.ofNullable(exitAction);
        transitions.forEach(this::markConnectedNode);
        this.markConnectedNode(defaultTransition.orElse(null));
    }

    private void markConnectedNode(Transition<?, S, C, D> transition) {
        if (transition == null) {
            return;
        }
        S toState = transition.getToState();
        if (!this.connectedNodes.contains(toState)) {
            this.connectedNodes.add(toState);
        }
    }

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public Optional<BiConsumer<C, D>> getEnterAction() {
        return this.enterAction;
    }

    @Override
    public Optional<BiConsumer<C, D>> getExitAction() {
        return this.exitAction;
    }

    @Override
    public boolean isInital() {
        return this.isInitial;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public List<S> getConnectedNodes() {
        return Collections.unmodifiableList(this.connectedNodes);
    }

    @Override
    public Optional<Transition<? extends Object, S, C, D>> accept(Object event, C ctx, D data) {
        Optional<Transition<Object, S, C, D>> optional = this.transitions.stream().filter(t -> t.match(event, ctx, data)).findFirst();
        if (optional.isPresent()) {
            return optional;
        }
        return this.defaultTransition;
    }
}

