/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.impl;

import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.FSM;
import io.hektor.fsm.PreConditions;
import io.hektor.fsm.State;
import io.hektor.fsm.Transition;
import io.hektor.fsm.TransitionListener;
import java.util.Optional;
import java.util.function.BiConsumer;

public class FsmImpl<S extends Enum<S>, C extends Context, D extends Data>
implements FSM<S, C, D> {
    private final Object uuid;
    private final BiConsumer<S, Object> unhandledEventHandler;
    private final TransitionListener<S> transitionListener;
    private final State[] states;
    private final S initialState;
    private final C ctx;
    private final D data;
    private State currentState;

    public FsmImpl(Object uuid, State[] states, S initialState, C ctx, D data, BiConsumer<S, Object> unhandledEventHandler, TransitionListener<S> transitionListener) {
        this.uuid = uuid;
        this.states = states;
        this.initialState = initialState;
        this.ctx = ctx;
        this.data = data;
        this.unhandledEventHandler = unhandledEventHandler;
        this.transitionListener = transitionListener;
    }

    @Override
    public final boolean isStarted() {
        return this.currentState != null;
    }

    @Override
    public final boolean isTerminated() {
        return this.currentState != null && this.currentState.isFinal();
    }

    @Override
    public final void start() {
        if (this.currentState != null) {
            return;
        }
        this.enterState(this.initialState);
    }

    @Override
    public void reStartAndEnter(S state) throws IllegalArgumentException {
        PreConditions.ensureNotNull(state);
        this.enterState(state);
    }

    private void enterState(S state) {
        this.currentState = this.states[((Enum)state).ordinal()];
        Optional action = this.currentState.getEnterAction();
        action.ifPresent(a -> a.accept(this.ctx, this.data));
    }

    private void exitCurrentState() {
        Optional action = this.currentState.getExitAction();
        action.ifPresent(a -> a.accept(this.ctx, this.data));
    }

    @Override
    public final void onEvent(Object event) {
        Optional optional = this.currentState.accept(event, this.ctx, this.data);
        if (optional.isPresent()) {
            this.transition(optional.get(), event);
            if (this.currentState.isTransient()) {
                this.onEvent(event);
            }
        } else if (this.unhandledEventHandler != null) {
            this.unhandledEventHandler.accept(this.currentState.getState(), event);
        }
    }

    private void transition(Transition<Object, S, C, D> transition, Object event) {
        try {
            S toState = transition.getToState();
            this.invokeTransitionListener(this.currentState.getState(), toState, event);
            transition.getAction().ifPresent(action -> action.accept(event));
            transition.getStatefulAction().ifPresent(action -> action.accept(event, this.ctx, this.data));
            if (this.currentState.getState() != toState) {
                this.exitCurrentState();
                this.enterState(toState);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void invokeTransitionListener(S fromState, S toState, Object event) {
        if (this.transitionListener == null) {
            return;
        }
        try {
            this.transitionListener.onTransition(fromState, toState, event);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public final S getState() {
        return this.currentState.getState();
    }
}

