/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.builder;

import io.hektor.fsm.Action;
import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.Guard;
import io.hektor.fsm.Transition;
import io.hektor.fsm.builder.DefaultTransitionBuilder;
import io.hektor.fsm.builder.exceptions.ActionAlreadyDefinedException;
import io.hektor.fsm.builder.exceptions.GuardAlreadyDefinedException;
import io.hektor.fsm.impl.TransitionImpl;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TransitionBuilder<E, S extends Enum<S>, C extends Context, D extends Data>
implements DefaultTransitionBuilder<E, S, C, D> {
    private final S toState;
    private final Class<E> event;
    private final boolean isDefault;
    private Predicate<E> guard;
    private Guard<E, C, D> richerGuard;
    private Consumer<E> action;
    private Action<E, C, D> statefulAction;

    public TransitionBuilder(S toState, Class<E> event) {
        this(toState, event, false);
    }

    public TransitionBuilder(S toState, Class<E> event, boolean isDefault) {
        this.toState = toState;
        this.event = event;
        this.isDefault = isDefault;
    }

    public TransitionBuilder<E, S, C, D> withGuard(Predicate<E> guard) {
        this.ensureGuardIsVisible();
        this.assertGuard();
        this.guard = guard;
        return this;
    }

    public TransitionBuilder<E, S, C, D> withGuard(Guard<E, C, D> guard) {
        this.ensureGuardIsVisible();
        this.assertGuard();
        this.richerGuard = guard;
        return this;
    }

    @Override
    public TransitionBuilder<E, S, C, D> consume() {
        return this.withAction((T e) -> {});
    }

    @Override
    public TransitionBuilder<E, S, C, D> withAction(Consumer<E> action) {
        this.assertAction();
        this.action = action;
        return this;
    }

    @Override
    public TransitionBuilder<E, S, C, D> withAction(Action<E, C, D> action) {
        this.assertAction();
        this.statefulAction = action;
        return this;
    }

    @Override
    public Transition<E, S, C, D> build() {
        return new TransitionImpl<E, S, C, D>(null, this.toState, this.event, this.guard, this.richerGuard, this.action, this.statefulAction);
    }

    private void assertGuard() throws GuardAlreadyDefinedException {
        if (this.guard != null || this.richerGuard != null) {
            throw new GuardAlreadyDefinedException("A guard has already been defined on this transition");
        }
    }

    private void assertAction() throws ActionAlreadyDefinedException {
        if (this.action != null || this.statefulAction != null) {
            throw new ActionAlreadyDefinedException("An action has already been defined on this transition");
        }
    }

    private void ensureGuardIsVisible() {
        if (this.isDefault) {
            throw new IllegalStateException("You cannot use a guard with the default transition");
        }
    }
}

