/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.builder;

import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.State;
import io.hektor.fsm.builder.DefaultTransitionBuilder;
import io.hektor.fsm.builder.EventBuildStep;
import io.hektor.fsm.builder.TransitionBuilder;
import io.hektor.fsm.builder.exceptions.DefaultTransitionAlreadySpecifiedException;
import io.hektor.fsm.builder.exceptions.FinalStateIsTransientException;
import io.hektor.fsm.builder.exceptions.FinalStateTransitionsException;
import io.hektor.fsm.builder.exceptions.TransientLoopDetectedException;
import io.hektor.fsm.builder.exceptions.TransientStateMissingTransitionException;
import io.hektor.fsm.builder.exceptions.TransitionMissingException;
import io.hektor.fsm.impl.StateImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class StateBuilder<S extends Enum<S>, C extends Context, D extends Data> {
    private final S state;
    private boolean isInitialState;
    private boolean isFinalState;
    private final List<TransitionBuilder<?, S, C, D>> transitions = new ArrayList();
    private TransitionBuilder<Object, S, C, D> defaultTransition;
    private BiConsumer<C, D> enterAction;
    private BiConsumer<C, D> exitAction;
    private final boolean isTransient;

    public StateBuilder(S state) {
        this(state, false);
    }

    public StateBuilder(S state, boolean isTransient) {
        this.state = state;
        this.isTransient = isTransient;
    }

    public S getState() {
        return this.state;
    }

    public StateBuilder<S, C, D> withEnterAction(BiConsumer<C, D> action) {
        this.enterAction = action;
        return this;
    }

    public StateBuilder<S, C, D> withExitAction(BiConsumer<C, D> action) {
        this.exitAction = action;
        return this;
    }

    public StateBuilder<S, C, D> withStateTimeout() {
        return this;
    }

    public EventBuildStep<S, C, D> transitionToSelf() {
        return this.transitionTo(this.state);
    }

    public EventBuildStep<S, C, D> transitionTo(S state) {
        return new EventBuildStep<S, C, D>((Enum)state){
            final /* synthetic */ Enum val$state;
            {
                this.val$state = enum_;
            }

            @Override
            public <E> TransitionBuilder<E, S, C, D> onEvent(Class<E> event) {
                StateBuilder.this.ensureTransientTransition(this.val$state);
                TransitionBuilder builder = new TransitionBuilder(this.val$state, event);
                StateBuilder.this.transitions.add(builder);
                return builder;
            }

            @Override
            public DefaultTransitionBuilder<Object, S, C, D> asDefaultTransition() {
                if (StateBuilder.this.defaultTransition != null) {
                    throw new DefaultTransitionAlreadySpecifiedException(this.val$state);
                }
                StateBuilder.this.ensureTransientTransition(this.val$state);
                TransitionBuilder builder = new TransitionBuilder(this.val$state, Object.class, true);
                StateBuilder.this.defaultTransition = builder;
                return builder;
            }
        };
    }

    private void ensureTransientTransition(S toState) {
        if (this.isTransient && this.state == toState) {
            throw new TransientLoopDetectedException((Enum)this.state);
        }
    }

    public State build() {
        if (this.isFinalState && !this.transitions.isEmpty()) {
            throw new FinalStateTransitionsException((Enum)this.state);
        }
        if (!this.isFinalState && this.transitions.isEmpty() && this.defaultTransition == null) {
            throw new TransitionMissingException((Enum)this.state);
        }
        if (this.isFinalState && this.isTransient) {
            throw new FinalStateIsTransientException((Enum)this.state);
        }
        if (this.isTransient && this.defaultTransition == null) {
            throw new TransientStateMissingTransitionException((Enum)this.state);
        }
        List ts = this.transitions.stream().map(TransitionBuilder::build).collect(Collectors.toList());
        Optional<Object> defaultTs = Optional.ofNullable(this.defaultTransition == null ? null : this.defaultTransition.build());
        return new StateImpl(this.state, this.isInitialState, this.isFinalState, this.isTransient, ts, defaultTs, this.enterAction, this.exitAction);
    }

    public StateBuilder<S, C, D> isInital(boolean value) {
        this.isInitialState = value;
        return this;
    }

    public boolean isInital() {
        return this.isInitialState;
    }

    public StateBuilder<S, C, D> isFinal(boolean value) {
        this.isFinalState = value;
        return this;
    }

    public boolean isFinal() {
        return this.isFinalState;
    }
}

