/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm.builder;

import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.Definition;
import io.hektor.fsm.State;
import io.hektor.fsm.builder.StateBuilder;
import io.hektor.fsm.builder.exceptions.FSMBuilderException;
import io.hektor.fsm.builder.exceptions.FinalStateAlreadyDefinedException;
import io.hektor.fsm.builder.exceptions.InitialStateAlreadyDefinedException;
import io.hektor.fsm.builder.exceptions.StateAlreadyDefinedException;
import io.hektor.fsm.builder.exceptions.StateNotDefinedException;
import io.hektor.fsm.builder.exceptions.TransientLoopDetectedException;
import io.hektor.fsm.impl.DefinitionImpl;
import java.util.Arrays;

public class FSMBuilder<S extends Enum<S>, C extends Context, D extends Data> {
    private final StateBuilder<S, C, D>[] states;

    public FSMBuilder(S[] possibleStates) {
        this.states = new StateBuilder[possibleStates.length];
    }

    public StateBuilder<S, C, D> withInitialState(S state) {
        if (this.hasInitialState()) {
            throw new InitialStateAlreadyDefinedException((Enum)state);
        }
        StateBuilder<S, C, D> builder = this.defineState(state, false);
        builder.isInital(true);
        return builder;
    }

    public StateBuilder<S, C, D> withFinalState(S state) {
        if (this.hasFinalState()) {
            throw new FinalStateAlreadyDefinedException((Enum)state);
        }
        StateBuilder<S, C, D> builder = this.defineState(state, false);
        builder.isFinal(true);
        return builder;
    }

    private boolean hasFinalState() {
        return Arrays.stream(this.states).filter(b -> b != null && b.isFinal()).findFirst().isPresent();
    }

    private boolean hasInitialState() {
        return Arrays.stream(this.states).filter(b -> b != null && b.isInital()).findFirst().isPresent();
    }

    public StateBuilder<S, C, D> withState(S state) throws StateAlreadyDefinedException {
        return this.defineState(state, false);
    }

    public StateBuilder<S, C, D> withTransientState(S state) throws StateAlreadyDefinedException {
        return this.defineState(state, true);
    }

    private StateBuilder<S, C, D> defineState(S state, boolean isTransient) throws StateAlreadyDefinedException {
        StateBuilder builder = new StateBuilder(state, isTransient);
        if (this.states[((Enum)state).ordinal()] != null) {
            throw new StateAlreadyDefinedException((Enum)state);
        }
        this.states[((Enum)state).ordinal()] = builder;
        return builder;
    }

    public Definition<S, C, D> build() throws FSMBuilderException {
        if (!this.hasInitialState()) {
            throw new FSMBuilderException("FSM is missing an initial state");
        }
        if (!this.hasFinalState()) {
            throw new FSMBuilderException("FSM is missing a final state");
        }
        State[] states = new State[this.states.length];
        for (int i = 0; i < states.length; ++i) {
            StateBuilder<S, C, D> builder = this.states[i];
            states[i] = builder != null ? builder.build() : null;
        }
        this.checkTransitions(states);
        return new DefinitionImpl(states);
    }

    private void checkTransitions(State<S, C, D>[] states) throws TransientLoopDetectedException {
        for (State state : states) {
            if (state == null) continue;
            state.getConnectedNodes().forEach(s -> {
                State toState = states[s.ordinal()];
                if (toState == null) {
                    throw new StateNotDefinedException((Enum)s);
                }
                if (state.isTransient() && toState.isTransient() && state.equals(toState)) {
                    throw new TransientLoopDetectedException((Enum)state.getState());
                }
            });
        }
    }
}

