/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm;

public final class PreConditions {
    private PreConditions() {
    }

    public static <T> T ensureNotNull(T reference, String msg) throws IllegalArgumentException {
        if (reference == null) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNotNull(T reference) throws IllegalArgumentException {
        if (reference == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return reference;
    }

    public static boolean checkIfEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean checkIfNotEmpty(String string) {
        return !PreConditions.checkIfEmpty(string);
    }

    public static String ensureNotEmpty(String reference, String msg) throws IllegalArgumentException {
        if (reference == null || reference.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static void ensureArgument(boolean expression, String msg) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> T ifNull(T reference, T defaultValue) {
        if (reference == null) {
            return defaultValue;
        }
        return reference;
    }
}

