/*
 * Decompiled with CFR 0.152.
 */
package io.hektor.fsm;

import io.hektor.fsm.Context;
import io.hektor.fsm.Data;
import io.hektor.fsm.builder.ContextTypeBuildStep;
import io.hektor.fsm.builder.DataTypeBuildStep;
import io.hektor.fsm.builder.FSMBuilder;

public interface FSM<S extends Enum<S>, C extends Context, D extends Data> {
    public void start();

    public boolean isStarted();

    public boolean isTerminated();

    public void reStartAndEnter(S var1) throws IllegalArgumentException;

    public void onEvent(Object var1);

    public S getState();

    public static <S extends Enum<S>> ContextTypeBuildStep<S> of(Class<S> type) {
        final Enum[] possibleStates = (Enum[])type.getEnumConstants();
        return new ContextTypeBuildStep<S>(){

            @Override
            public <C extends Context> DataTypeBuildStep<S, C> ofContextType(Class<C> type) {
                return new DataTypeBuildStep<S, C>(){

                    @Override
                    public <D extends Data> FSMBuilder<S, C, D> withDataType(Class<D> type) {
                        return new FSMBuilder(possibleStates);
                    }
                };
            }
        };
    }
}

