/*
 * Decompiled with CFR 0.152.
 */
package io.hekate.cluster.seed.jclouds;

import com.google.common.collect.ImmutableSet;
import io.hekate.cluster.seed.SeedNodeProvider;
import io.hekate.cluster.seed.jclouds.CloudStoreSeedNodeProviderConfig;
import io.hekate.cluster.seed.jclouds.CredentialsSupplier;
import io.hekate.core.HekateException;
import io.hekate.core.internal.util.AddressUtils;
import io.hekate.core.internal.util.ArgAssert;
import io.hekate.core.internal.util.ConfigCheck;
import io.hekate.core.internal.util.ErrorUtils;
import io.hekate.core.report.ConfigReportSupport;
import io.hekate.core.report.ConfigReporter;
import io.hekate.util.format.ToString;
import io.hekate.util.format.ToStringIgnore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.rest.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreSeedNodeProvider
implements SeedNodeProvider,
ConfigReportSupport {
    private static final Logger log = LoggerFactory.getLogger(CloudStoreSeedNodeProvider.class);
    private final String provider;
    private final String container;
    private final Properties properties;
    private final long cleanupInterval;
    @ToStringIgnore
    private final CredentialsSupplier credentials;

    public CloudStoreSeedNodeProvider(CloudStoreSeedNodeProviderConfig cfg) {
        ArgAssert.notNull((Object)cfg, (String)"Configuration");
        ConfigCheck check = ConfigCheck.get(CloudStoreSeedNodeProvider.class);
        check.notNull((Object)cfg.getProvider(), "provider");
        check.notNull((Object)cfg.getCredentials(), "credentials");
        check.notEmpty(cfg.getContainer(), "container");
        this.provider = cfg.getProvider();
        this.container = cfg.getContainer().trim();
        this.credentials = cfg.getCredentials();
        this.cleanupInterval = cfg.getCleanupInterval();
        Properties properties = cfg.buildBaseProperties();
        if (cfg.getProperties() != null) {
            cfg.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        }
        this.properties = properties;
    }

    public void report(ConfigReporter report) {
        report.section("cloud-store", r -> {
            r.value("provider", (Object)this.provider);
            r.value("container", (Object)this.container);
            r.value("properties", (Object)this.properties);
            r.value("cleanup-interval", (Object)this.cleanupInterval);
        });
    }

    public String provider() {
        return this.provider;
    }

    public String container() {
        return this.container;
    }

    public Properties properties() {
        Properties copy = new Properties();
        for (String name : this.properties.stringPropertyNames()) {
            copy.setProperty(name, this.properties.getProperty(name));
        }
        return copy;
    }

    public void startDiscovery(String cluster, InetSocketAddress node) throws HekateException {
        this.registerAddress(cluster, node);
    }

    public void stopDiscovery(String cluster, InetSocketAddress node) throws HekateException {
        this.unregisterAddress(cluster, node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InetSocketAddress> findSeedNodes(String cluster) throws HekateException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Loading seed node addresses [container={}, cluster={}]", (Object)this.container, (Object)cluster);
            }
            try (BlobStoreContext ctx = this.createContext();){
                PageSet pageSet;
                BlobStore store = ctx.getBlobStore();
                ArrayList<InetSocketAddress> seedNodes = new ArrayList<InetSocketAddress>();
                String marker = null;
                do {
                    ListContainerOptions opts = ListContainerOptions.Builder.prefix((String)(cluster + "/"));
                    if (marker != null) {
                        opts.afterMarker(marker);
                    }
                    pageSet = store.list(this.container, opts);
                    if (log.isDebugEnabled()) {
                        log.debug("Loaded blobs list [size={}, marker={}]", (Object)pageSet.size(), marker);
                    }
                    for (StorageMetadata metaData : pageSet) {
                        InetSocketAddress address;
                        int lastCharIdx;
                        if (metaData.getType() != StorageType.BLOB) continue;
                        String name = metaData.getName();
                        if ((name.startsWith(cluster + '/') || name.startsWith(cluster + '\\')) && name.length() > cluster.length() + 1) {
                            name = name.substring(cluster.length() + 1);
                        }
                        if (name.length() > 1 && (name.charAt(lastCharIdx = name.length() - 1) == '/' || name.charAt(lastCharIdx) == '\\')) {
                            name = name.substring(0, lastCharIdx);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Processing blob [name={}]", (Object)name);
                        }
                        if ((address = AddressUtils.fromFileName((String)name, (Logger)log)) == null) continue;
                        seedNodes.add(address);
                    }
                } while ((marker = pageSet.getNextMarker()) != null);
                ArrayList<InetSocketAddress> arrayList = seedNodes;
                return arrayList;
            }
        }
        catch (ContainerNotFoundException e) {
            if (!log.isWarnEnabled()) return Collections.emptyList();
            log.warn("Failed to load seed nodes list [container={}, cluster={}, cause={}]", new Object[]{this.container, cluster, e.toString()});
            return Collections.emptyList();
        }
        catch (HttpResponseException e) {
            if (!ErrorUtils.isCausedBy(IOException.class, (Throwable)e)) throw e;
            throw new HekateException("Cloud provider connection failure [provider=" + this.provider + ']', (Throwable)e);
        }
    }

    public void registerRemote(String cluster, InetSocketAddress node) throws HekateException {
        this.registerAddress(cluster, node);
    }

    public void unregisterRemote(String cluster, InetSocketAddress node) throws HekateException {
        this.unregisterAddress(cluster, node);
    }

    public void suspendDiscovery() throws HekateException {
    }

    public long cleanupInterval() {
        return this.cleanupInterval;
    }

    private BlobStoreContext createContext() {
        ContextBuilder builder = ContextBuilder.newBuilder((String)this.provider).credentialsSupplier(this.credentials::get).modules((Iterable)ImmutableSet.of((Object)new SLF4JLoggingModule()));
        if (!this.properties.isEmpty()) {
            builder.overrides(this.properties);
        }
        return (BlobStoreContext)builder.buildView(BlobStoreContext.class);
    }

    private void registerAddress(String cluster, InetSocketAddress address) throws HekateException {
        try (BlobStoreContext ctx = this.createContext();){
            BlobStore store = ctx.getBlobStore();
            String file = cluster + '/' + AddressUtils.toFileName((InetSocketAddress)address);
            try {
                if (!store.blobExists(this.container, file)) {
                    Blob blob = store.blobBuilder(file).type(StorageType.BLOB).payload(new byte[]{1}).build();
                    store.putBlob(this.container, blob);
                    if (log.isInfoEnabled()) {
                        log.info("Registered address to the cloud store [container={}, file={}]", (Object)this.container, (Object)file);
                    }
                }
            }
            catch (HttpResponseException | ResourceNotFoundException e) {
                throw new HekateException("Failed to register the seed node address to the cloud store [container=" + this.container + ", file=" + file + ']', e);
            }
        }
    }

    private void unregisterAddress(String cluster, InetSocketAddress address) {
        try (BlobStoreContext ctx = this.createContext();){
            BlobStore store = ctx.getBlobStore();
            String file = cluster + '/' + AddressUtils.toFileName((InetSocketAddress)address);
            try {
                if (store.blobExists(this.container, file)) {
                    store.removeBlob(this.container, file);
                    if (log.isInfoEnabled()) {
                        log.info("Unregistered address from the cloud store [container={}, file={}]", (Object)this.container, (Object)file);
                    }
                }
            }
            catch (HttpResponseException | ResourceNotFoundException e) {
                if (log.isWarnEnabled()) {
                    log.warn("Failed to unregister the seed node address from the cloud store [container={}, file={}, cause={}]", new Object[]{this.container, file, e.toString()});
                }
            }
        }
    }

    public String toString() {
        return ToString.format((Object)this);
    }
}

