/*
 * Decompiled with CFR 0.152.
 */
package io.hekate.cluster.seed.jclouds;

import io.hekate.cluster.seed.jclouds.CredentialsSupplier;
import io.hekate.util.format.ToString;
import io.hekate.util.format.ToStringIgnore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CloudSeedNodeProviderConfig {
    private String provider;
    private String endpoint;
    private Set<String> regions;
    private Set<String> zones;
    private Map<String, String> tags;
    private Properties properties;
    @ToStringIgnore
    private CredentialsSupplier credentials;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CloudSeedNodeProviderConfig withProvider(String provider) {
        this.setProvider(provider);
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public CloudSeedNodeProviderConfig withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public CredentialsSupplier getCredentials() {
        return this.credentials;
    }

    public void setCredentials(CredentialsSupplier credentials) {
        this.credentials = credentials;
    }

    public CloudSeedNodeProviderConfig withCredentials(CredentialsSupplier credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public CloudSeedNodeProviderConfig withProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        return this;
    }

    public Set<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Set<String> regions) {
        this.regions = regions;
    }

    public CloudSeedNodeProviderConfig withRegion(String region) {
        if (this.regions == null) {
            this.regions = new HashSet<String>();
        }
        this.regions.add(region);
        return this;
    }

    public Set<String> getZones() {
        return this.zones;
    }

    public void setZones(Set<String> zones) {
        this.zones = zones;
    }

    public CloudSeedNodeProviderConfig withZone(String zone) {
        if (this.zones == null) {
            this.zones = new HashSet<String>();
        }
        this.zones.add(zone);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CloudSeedNodeProviderConfig withTag(String name, String value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(name, value);
        return this;
    }

    public String toString() {
        return ToString.format((Object)this);
    }
}

