/*
 * Decompiled with CFR 0.152.
 */
package io.hekate.cluster.seed.jclouds;

import com.google.common.collect.ImmutableSet;
import io.hekate.cluster.seed.SeedNodeProvider;
import io.hekate.cluster.seed.jclouds.CloudSeedNodeProviderConfig;
import io.hekate.cluster.seed.jclouds.CredentialsSupplier;
import io.hekate.core.HekateException;
import io.hekate.core.internal.util.ArgAssert;
import io.hekate.core.internal.util.ConfigCheck;
import io.hekate.core.internal.util.ErrorUtils;
import io.hekate.core.internal.util.StreamUtils;
import io.hekate.util.format.ToString;
import io.hekate.util.format.ToStringIgnore;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudSeedNodeProvider
implements SeedNodeProvider {
    private static final Logger log = LoggerFactory.getLogger(CloudSeedNodeProvider.class);
    private final String provider;
    private final String endpoint;
    private final Properties properties;
    private final Set<String> regions;
    private final Set<String> zones;
    private final Map<String, String> tags;
    @ToStringIgnore
    private final CredentialsSupplier credentials;
    @ToStringIgnore
    private int port;

    public CloudSeedNodeProvider(CloudSeedNodeProviderConfig cfg) {
        ArgAssert.notNull((Object)cfg, (String)"Configuration");
        ConfigCheck check = ConfigCheck.get(CloudSeedNodeProviderConfig.class);
        check.notNull((Object)cfg.getProvider(), "provider");
        check.notNull((Object)cfg.getCredentials(), "credentials");
        this.provider = cfg.getProvider();
        this.credentials = cfg.getCredentials();
        this.endpoint = cfg.getEndpoint();
        this.regions = StreamUtils.nullSafe(cfg.getRegions()).collect(Collectors.toSet());
        this.zones = StreamUtils.nullSafe(cfg.getZones()).collect(Collectors.toSet());
        Properties properties = new Properties();
        if (!this.regions.isEmpty()) {
            properties.setProperty("jclouds.regions", this.regions.stream().collect(Collectors.joining(",")));
        }
        if (!this.zones.isEmpty()) {
            properties.setProperty("jclouds.zones", this.zones.stream().collect(Collectors.joining(",")));
        }
        if (cfg.getProperties() != null) {
            cfg.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        }
        this.properties = properties;
        this.tags = cfg.getTags() != null ? new HashMap<String, String>(cfg.getTags()) : Collections.emptyMap();
    }

    public void startDiscovery(String cluster, InetSocketAddress node) throws HekateException {
        this.port = node.getPort();
    }

    public void stopDiscovery(String cluster, InetSocketAddress node) throws HekateException {
    }

    public List<InetSocketAddress> findSeedNodes(String cluster) throws HekateException {
        return this.withCompute(ctx -> {
            try {
                ComputeService compute = ctx.getComputeService();
                Set hosts = compute.listNodesDetailsMatching(Objects::nonNull).stream().filter(node -> {
                    if (!this.acceptState((NodeMetadata)node)) {
                        return false;
                    }
                    Location location = node.getLocation();
                    if (!this.acceptLocation(location, this.regions, LocationScope.REGION)) {
                        return false;
                    }
                    if (!this.acceptLocation(location, this.zones, LocationScope.ZONE)) {
                        return false;
                    }
                    if (!this.tags.isEmpty()) {
                        Map metaData = node.getUserMetadata();
                        if (metaData == null || metaData.isEmpty()) {
                            return false;
                        }
                        for (Map.Entry<String, String> e : this.tags.entrySet()) {
                            if (Objects.equals(e.getValue(), metaData.get(e.getKey()))) continue;
                            return false;
                        }
                    }
                    return true;
                }).flatMap(node -> node.getPrivateAddresses().stream()).collect(Collectors.toSet());
                ArrayList<InetSocketAddress> seedNodes = new ArrayList<InetSocketAddress>(hosts.size());
                for (String host : hosts) {
                    try {
                        InetAddress address = InetAddress.getByName(host);
                        seedNodes.add(new InetSocketAddress(address, this.port));
                    }
                    catch (UnknownHostException e) {
                        log.warn("Failed to resolve cloud node address [host={}]", (Object)host, (Object)e);
                    }
                }
                return seedNodes;
            }
            catch (HttpResponseException e) {
                if (ErrorUtils.isCausedBy((Throwable)e, IOException.class)) {
                    throw new HekateException("Cloud provider connection failure [provider=" + this.provider + ']', (Throwable)e);
                }
                throw e;
            }
        });
    }

    public void suspendDiscovery() throws HekateException {
    }

    public long cleanupInterval() {
        return 0L;
    }

    public void registerRemote(String cluster, InetSocketAddress node) throws HekateException {
    }

    public void unregisterRemote(String cluster, InetSocketAddress node) throws HekateException {
    }

    boolean acceptState(NodeMetadata node) {
        return node.getStatus() == NodeMetadata.Status.RUNNING;
    }

    private boolean acceptLocation(Location location, Set<String> names, LocationScope scope) {
        if (names.isEmpty()) {
            return true;
        }
        while (location != null) {
            if (location.getScope() == scope && names.contains(location.getId())) {
                return true;
            }
            location = location.getParent();
        }
        return false;
    }

    private <T> T withCompute(ComputeTask<T> task) throws HekateException {
        ContextBuilder builder = ContextBuilder.newBuilder((String)this.provider).credentialsSupplier(this.credentials::get).modules((Iterable)ImmutableSet.of((Object)new SLF4JLoggingModule()));
        if (!this.properties.isEmpty()) {
            builder.overrides(this.properties);
        }
        if (this.endpoint != null && !this.endpoint.trim().isEmpty()) {
            builder.endpoint(this.endpoint.trim());
        }
        try (ComputeServiceContext ctx = (ComputeServiceContext)builder.buildView(ComputeServiceContext.class);){
            T t = task.execute(ctx);
            return t;
        }
    }

    public String toString() {
        return ToString.format((Object)this);
    }

    private static interface ComputeTask<T> {
        public T execute(ComputeServiceContext var1) throws HekateException;
    }
}

