/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.webauthn.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class CredentialQuery {
    private Integer page;
    private Integer pageSize;
    private String userId;

    public CredentialQuery() {
    }

    @JsonCreator
    public CredentialQuery(@JsonProperty(value="page") Integer page, @JsonProperty(value="page_size") Integer pageSize, @JsonProperty(value="user_id") String userId) {
        this.page = page;
        this.pageSize = pageSize;
        this.userId = userId;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getUserid() {
        return this.userId;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public String toQueryString() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (this.userId != null && !this.userId.isEmpty()) {
            params.add(new BasicNameValuePair("user_id", this.userId));
        }
        if (this.page != null) {
            params.add(new BasicNameValuePair("page", Integer.toString(this.page)));
        }
        if (this.pageSize != null) {
            params.add(new BasicNameValuePair("page_size", Integer.toString(this.pageSize)));
        }
        if (!params.isEmpty()) {
            return "?" + URLEncodedUtils.format(params, (Charset)Charset.forName(StandardCharsets.UTF_8.name()));
        }
        return "";
    }
}

