/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.hanko.sdk.exception.HankoClientException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class HankoJsonParser {
    private final String COULD_NOT_DESERIALIZE_FORMAT = "Could not deserialize: %s";
    private final ObjectMapper mapper = new ObjectMapper();

    public HankoJsonParser() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T> T deserialize(InputStream is, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(is, valueType);
        }
        catch (IOException ex) {
            throw new HankoClientException(String.format("Could not deserialize: %s", ex.getMessage()), ex);
        }
    }

    public <T> T deserialize(String s, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(s, valueType);
        }
        catch (IOException ex) {
            throw new HankoClientException(String.format("Could not deserialize: %s", ex.getMessage()), ex);
        }
    }

    public <T> T deserialize(File f, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(f, valueType);
        }
        catch (IOException ex) {
            throw new HankoClientException(String.format("Could not deserialize: %s", ex.getMessage()), ex);
        }
    }

    public <T> List<T> deserializeList(InputStream is, Class<T> valueType) {
        CollectionType type = this.mapper.getTypeFactory().constructCollectionType(List.class, valueType);
        try {
            return (List)this.mapper.readValue(is, (JavaType)type);
        }
        catch (IOException ex) {
            throw new HankoClientException(String.format("Could not deserialize: %s", ex.getMessage()), ex);
        }
    }

    public <T> String serialize(T value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (IOException ex) {
            throw new HankoClientException("Could not serialize: " + ex.getMessage(), ex);
        }
    }
}

