/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.http;

import io.hanko.sdk.config.HankoClientConfig;
import io.hanko.sdk.exception.HankoApiConnectionException;
import io.hanko.sdk.http.HankoHttpResponse;
import io.hanko.sdk.http.HttpMethod;
import io.hanko.sdk.util.HmacUtil;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;

public abstract class HankoHttpClientBase {
    private final CloseableHttpClient httpClient;
    private final HankoClientConfig config;

    protected HankoHttpClientBase(HankoClientConfig config, CloseableHttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient must not be null");
        this.config = Objects.requireNonNull(config, "config must not be null");
    }

    protected HankoHttpResponse makeRequest(HttpMethod method, String path) {
        return this.makeRequest(method, path, null);
    }

    protected HankoHttpResponse makeRequest(HttpMethod method, String path, String body) {
        HankoHttpResponse hankoHttpResponse;
        String url = this.constructUrl(path);
        RequestBuilder builder = RequestBuilder.create((String)method.toString()).setUri(url);
        String authHeader = HmacUtil.makeAuthorizationHeader(this.config.getApiSecret(), this.config.getApiKeyId(), builder.getMethod(), builder.getUri().getPath(), body);
        builder.setHeader("Authorization", authHeader);
        this.logRequest(method, url, body, authHeader);
        if (body != null) {
            builder.setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute(builder.build());
            HttpEntity entity = response.getEntity();
            hankoHttpResponse = new HankoHttpResponse(entity == null ? null : new BufferedHttpEntity(entity).getContent(), response.getStatusLine().getStatusCode(), path);
        }
        catch (IOException ex) {
            try {
                throw new HankoApiConnectionException("Could not connect to Hanko API", ex);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return hankoHttpResponse;
    }

    private String constructUrl(String path) {
        String baseUrl = this.config.getApiUrl().toString();
        baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        return baseUrl + path;
    }

    protected abstract Logger getLogger();

    private void logRequest(HttpMethod method, String url, String body, String authHeader) {
        Logger logger = this.getLogger();
        logger.debug("-- BEGIN Hanko API Request --");
        logger.debug("request method: {}", (Object)method);
        logger.debug("request URL: {}", (Object)url);
        logger.debug("authorization: {}", (Object)authHeader);
        if (body != null) {
            logger.debug("body: {}", (Object)body);
        }
        logger.debug("-- END Hanko API Request --");
    }
}

