/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.webauthn;

import io.hanko.sdk.config.HankoClientConfig;
import io.hanko.sdk.http.HankoHttpClient;
import io.hanko.sdk.http.HankoHttpResponse;
import io.hanko.sdk.json.HankoJsonParser;
import io.hanko.sdk.webauthn.api.AuthenticationInitializationRequest;
import io.hanko.sdk.webauthn.api.CredentialQuery;
import io.hanko.sdk.webauthn.api.CredentialUpdateRequest;
import io.hanko.sdk.webauthn.api.FinalizationResponse;
import io.hanko.sdk.webauthn.api.RegistrationInitializationRequest;
import io.hanko.sdk.webauthn.api.TransactionInitializationRequest;
import io.hanko.sdk.webauthn.api.WebAuthnCredential;
import java.util.List;
import java.util.Objects;
import org.apache.http.impl.client.CloseableHttpClient;

public class HankoWebAuthnClient {
    private final HankoHttpClient httpClient;
    private final HankoJsonParser parser = new HankoJsonParser();

    public HankoWebAuthnClient(HankoClientConfig hankoClientConfig) {
        this.httpClient = new HankoHttpClient(hankoClientConfig);
    }

    public HankoWebAuthnClient(HankoClientConfig hankoClientConfig, CloseableHttpClient httpClient) {
        this.httpClient = new HankoHttpClient(hankoClientConfig, httpClient);
    }

    public HankoWebAuthnClient(HankoHttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient must not be null");
    }

    public String initializeRegistration(RegistrationInitializationRequest request) {
        String body = this.parser.serialize(request);
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/registration/initialize", body);
        return response.getContent();
    }

    public FinalizationResponse finalizeRegistration(String webAuthnResponse) {
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/registration/finalize", webAuthnResponse);
        return this.parser.deserialize(response.getStream(), FinalizationResponse.class);
    }

    public String initializeAuthentication(AuthenticationInitializationRequest request) {
        String body = this.parser.serialize(request);
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/authentication/initialize", body);
        return response.getContent();
    }

    public FinalizationResponse finalizeAuthentication(String webAuthnResponse) {
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/authentication/finalize", webAuthnResponse);
        return this.parser.deserialize(response.getStream(), FinalizationResponse.class);
    }

    public String initializeTransaction(TransactionInitializationRequest request) {
        String body = this.parser.serialize(request);
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/transaction/initialize", body);
        return response.getContent();
    }

    public FinalizationResponse finalizeTransaction(String webAuthnResponse) {
        HankoHttpResponse response = this.httpClient.post("/v1/webauthn/transaction/finalize", webAuthnResponse);
        return this.parser.deserialize(response.getStream(), FinalizationResponse.class);
    }

    public WebAuthnCredential getCredential(String credentialId) {
        HankoHttpResponse response = this.httpClient.get("/v1/webauthn/credentials/" + credentialId);
        return this.parser.deserialize(response.getStream(), WebAuthnCredential.class);
    }

    public List<WebAuthnCredential> listCredentials(CredentialQuery query) {
        String path = query == null ? "/v1/webauthn/credentials/" : "/v1/webauthn/credentials/" + query.toQueryString();
        HankoHttpResponse response = this.httpClient.get(path);
        return this.parser.deserializeList(response.getStream(), WebAuthnCredential.class);
    }

    public boolean deleteCredential(String credentialId) {
        HankoHttpResponse response = this.httpClient.delete("/v1/webauthn/credentials/" + credentialId);
        return response.getStatusCode() == 204;
    }

    public WebAuthnCredential updateCredential(String credentialId, CredentialUpdateRequest request) {
        String body = this.parser.serialize(request);
        HankoHttpResponse response = this.httpClient.put("/v1/webauthn/credentials/" + credentialId, body);
        return this.parser.deserialize(response.getStream(), WebAuthnCredential.class);
    }
}

